/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.model;

import org.netbeans.modules.html.angular.model.Directive;
import org.netbeans.modules.web.common.api.LexerUtils;

public enum DirectiveConvention {
    data_dash("data", '-'),
    data_underscore("data", '_'),
    data_colon("data", ':'),
    x_dash("x", '-'),
    x_underscore("x", '_'),
    x_colon("x", ':'),
    base_dash(null, '-'),
    base_underscore(null, '_'),
    base_colon(null, ':');

    private static final String NG_PREFIX = "ng";
    private final char delimiter;
    private final String fullPrefix;

    private DirectiveConvention(String prefix, char delimiter) {
        this.delimiter = delimiter;
        this.fullPrefix = prefix == null ? NG_PREFIX : prefix + '-' + NG_PREFIX;
    }

    String createFQN(Directive directive) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fullPrefix);
        sb.append(this.delimiter);
        sb.append(directive.getAttributeCoreName(this.delimiter));
        return sb.toString();
    }

    public static DirectiveConvention getConvention(CharSequence attributeName) {
        for (DirectiveConvention dc : DirectiveConvention.values()) {
            char delimiterChar;
            if (!LexerUtils.startsWith((CharSequence)attributeName, (CharSequence)dc.fullPrefix, (boolean)true, (boolean)false) || attributeName.length() <= dc.fullPrefix.length() || dc.delimiter != (delimiterChar = attributeName.charAt(dc.fullPrefix.length()))) continue;
            return dc;
        }
        return null;
    }
}

