/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.hudson.api.Bundle;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NetworkSettings;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ConnectionBuilder {
    private static final Logger LOG = Logger.getLogger(ConnectionBuilder.class.getName());
    private static final RequestProcessor TIMER = new RequestProcessor(ConnectionBuilder.class.getName() + ".TIMER");
    private static final Set<String> authenticationRejected = new HashSet<String>();
    private static final Map<String, String[]> COOKIES = new HashMap<String, String[]>();
    private static final Map<String, String[]> crumbs = Collections.synchronizedMap(new HashMap());
    private URL home;
    private URL url;
    private final Map<String, String> requestHeaders = new LinkedHashMap<String, String>();
    private byte[] postData;
    private int timeout;
    private boolean auth = true;
    private boolean followRedirects = true;

    public ConnectionBuilder url(URL url) {
        this.url = url;
        return this;
    }

    public ConnectionBuilder url(String url) throws MalformedURLException {
        return this.url(new URL(url));
    }

    public ConnectionBuilder homeURL(URL url) {
        this.home = url;
        return this;
    }

    public ConnectionBuilder homeURL(String url) throws MalformedURLException {
        this.home = new URL(url);
        return this;
    }

    public ConnectionBuilder instance(HudsonInstance instance) {
        try {
            this.home = new URL(instance.getUrl());
        }
        catch (MalformedURLException x) {
            LOG.warning(x.toString());
        }
        return this;
    }

    public ConnectionBuilder job(HudsonJob job) {
        HudsonInstance instance = job.getInstance();
        if (instance != null) {
            this.instance(instance);
        }
        return this;
    }

    public ConnectionBuilder header(String key, String value) {
        this.requestHeaders.put(key, value);
        return this;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public ConnectionBuilder postData(byte[] data) {
        this.postData = data;
        return this;
    }

    public ConnectionBuilder timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public ConnectionBuilder authentication(boolean a) {
        this.auth = a;
        return this;
    }

    public ConnectionBuilder followRedirects(boolean fr) {
        this.followRedirects = fr;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection connection() throws IOException {
        if (this.url == null) {
            throw new IllegalArgumentException("You must call the url method!");
        }
        if (this.url.getProtocol().matches("https?") && EventQueue.isDispatchThread()) {
            throw new IOException("#184196: refusing to open " + this.url + " from EQ");
        }
        if (this.timeout == 0) {
            return this.doConnection();
        }
        final Thread curr = Thread.currentThread();
        RequestProcessor.Task task = TIMER.post(new Runnable(){

            @Override
            public void run() {
                curr.interrupt();
            }
        }, this.timeout);
        try {
            URLConnection uRLConnection = this.doConnection();
            return uRLConnection;
        }
        finally {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private URLConnection doConnection() throws IOException {
        conn = this.url.openConnection();
        block22: while (true) {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
            }
            if (conn instanceof HttpsURLConnection) {
                try {
                    sc = SSLContext.getInstance("SSL");
                    sc.init(null, new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }}, new SecureRandom());
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
                    ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                }
                catch (Exception x) {
                    ConnectionBuilder.LOG.log(Level.FINE, "could not disable SSL verification", x);
                }
            }
            curr = conn.getURL();
            ConnectionBuilder.LOG.log(Level.FINER, "Trying to open {0}", curr);
            if (this.home != null) {
                for (ConnectionAuthenticator authenticator : Lookup.getDefault().lookupAll(ConnectionAuthenticator.class)) {
                    authenticator.prepareRequest(conn, this.home);
                }
                if (ConnectionBuilder.COOKIES.containsKey(this.home.toString())) {
                    for (Object cookie : ConnectionBuilder.COOKIES.get(this.home.toString())) {
                        cookieBare = cookie.replaceFirst(";.*", "");
                        ConnectionBuilder.LOG.log(Level.FINER, "Setting cookie {0} for {1}", new Object[]{cookieBare, conn.getURL()});
                        conn.setRequestProperty("Cookie", cookieBare);
                    }
                }
                if ((fieldCrumb = ConnectionBuilder.crumbs.get(this.home.toString())) != null) {
                    conn.setRequestProperty(fieldCrumb[0], fieldCrumb[1]);
                }
            }
            if (this.postData != null) {
                conn.setDoOutput(true);
            }
            fieldCrumb = this.requestHeaders.entrySet().iterator();
            while (fieldCrumb.hasNext()) {
                header = fieldCrumb.next();
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
            try {
                conn.connect();
            }
            catch (IOException x) {
                throw x;
            }
            catch (Exception x) {
                throw new IOException("Connecting to " + curr + ": " + x, x);
            }
            if (this.postData != null) {
                os = conn.getOutputStream();
                try {
                    os.write(this.postData);
                }
                finally {
                    os.close();
                }
            }
            if (!(conn instanceof HttpURLConnection)) break;
            if (this.home != null && (cookies = this.getHeaderFields(conn).get("Set-Cookie")) != null) {
                ConnectionBuilder.LOG.log(Level.FINE, "Cookies set for domain {0}: {1}", new Object[]{this.home, cookies});
                ConnectionBuilder.COOKIES.put(this.home.toString(), cookies.toArray(new String[0]));
            }
            responseCode = ((HttpURLConnection)conn).getResponseCode();
            ConnectionBuilder.LOG.log(Level.FINER, "  => {0}", responseCode);
            switch (responseCode) {
                case 301: 
                case 302: {
                    if (!this.followRedirects) break block22;
                    redirect = new URL(conn.getHeaderField("Location"));
                    conn = redirect.openConnection();
                    continue block22;
                }
                case 403: {
                    if (!this.auth || this.home == null) ** GOTO lbl104
                    var5_13 = ConnectionBuilder.authenticationRejected;
                    synchronized (var5_13) {
                        if (ConnectionBuilder.authenticationRejected.contains(this.home.toString())) ** GOTO lbl104
                        cookie = Lookup.getDefault().lookupAll(ConnectionAuthenticator.class).iterator();
                        while (cookie.hasNext()) {
                            authenticator = (ConnectionAuthenticator)cookie.next();
                            retry = authenticator.forbidden(conn, this.home);
                            if (retry == null) continue;
                            ConnectionBuilder.LOG.log(Level.FINER, "Retrying after auth from {0}", authenticator);
                            conn = retry;
                            try {
                                is = new ConnectionBuilder().url(new URL(this.home, "crumbIssuer/api/xml?xpath=concat(//crumbRequestField,'=',//crumb)")).homeURL(this.home).connection().getInputStream();
                                try {
                                    baos = new ByteArrayOutputStream();
                                    FileUtil.copy((InputStream)is, (OutputStream)baos);
                                    crumb = baos.toString("UTF-8");
                                    crumbA = crumb.split("=", 2);
                                    if (crumbA.length == 2 && crumbA[0].indexOf(10) == -1) {
                                        ConnectionBuilder.LOG.log(Level.FINER, "Received crumb: {0}", crumb);
                                        ConnectionBuilder.crumbs.put(this.home.toString(), crumbA);
                                    } else {
                                        ConnectionBuilder.LOG.log(Level.WARNING, "Bad crumb response: {0}", crumb);
                                    }
                                }
                                finally {
                                    is.close();
                                }
                            }
                            catch (FileNotFoundException x) {
                                ConnectionBuilder.LOG.finer("not using crumbs");
                            }
                            continue block22;
                        }
                        ConnectionBuilder.authenticationRejected.add(this.home.toString());
                    }
lbl104:
                    // 3 sources

                    x = new HttpRetryException("403 on " + this.url, responseCode);
                    Exceptions.attachLocalizedMessage((Throwable)x, (String)Bundle.ConnectionBuilder_log_in(this.url));
                    throw x;
                }
                case 404: {
                    throw new FileNotFoundException(curr.toString());
                }
                case 200: {
                    break block22;
                }
                default: {
                    resMsg = ((HttpURLConnection)conn).getResponseMessage();
                    errMsg = "Server rejected connection to " + curr + " with code " + responseCode + (resMsg != null ? " and message " + resMsg : "");
                    throw new HttpRetryException(errMsg, responseCode);
                }
            }
            break;
        }
        return conn;
    }

    private Map<String, List<String>> getHeaderFields(final URLConnection conn) throws IOException {
        return this.callSilentlyIfNeeded(conn, new Callable<Map<String, List<String>>>(){

            @Override
            public Map<String, List<String>> call() throws Exception {
                return conn.getHeaderFields();
            }
        });
    }

    private <R> R callSilentlyIfNeeded(URLConnection conn, Callable<R> call) throws IOException {
        if (conn.getAllowUserInteraction()) {
            try {
                return call.call();
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        try {
            return (R)NetworkSettings.suppressAuthenticationDialog(call);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public HttpURLConnection httpConnection() throws IOException {
        URLConnection c = this.connection();
        if (c instanceof HttpURLConnection) {
            return (HttpURLConnection)c;
        }
        throw new IOException("Not an HTTP connection: " + c);
    }

    public Document parseXML() throws IOException {
        URLConnection c = this.connection();
        InputSource source = new InputSource(this.url.toString());
        source.setByteStream(c.getInputStream());
        try {
            return XMLUtil.parse((InputSource)source, (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (SAXException x) {
            throw new IOException(x);
        }
    }

    public static void clearRejectedAuthentication() {
        authenticationRejected.clear();
    }
}

