/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.navigation.CaretListeningFactory;
import org.netbeans.modules.java.navigation.ClassMemberPanel;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.netbeans.modules.java.navigation.base.Utils;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class CaretListeningTask
implements CancellableTask<CompilationInfo> {
    private FileObject fileObject;
    private final AtomicBoolean canceled;
    private static ElementHandle<Element> lastEh;
    private static ElementHandle<Element> lastEhForNavigator;
    private static final Set<JavaTokenId> TOKENS_TO_SKIP;

    CaretListeningTask(FileObject fileObject) {
        this.fileObject = fileObject;
        this.canceled = new AtomicBoolean();
    }

    static void resetLastEH() {
        lastEh = null;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        TreePath tp;
        Tree.Kind k;
        this.resume();
        boolean navigatorShouldUpdate = ClassMemberPanel.getInstance() != null;
        boolean javadocShouldUpdate = JavadocTopComponent.shouldUpdate();
        if (this.isCancelled() || !navigatorShouldUpdate && !javadocShouldUpdate) {
            return;
        }
        int lastPosition = CaretListeningFactory.getLastPosition((FileObject)this.fileObject);
        TokenHierarchy tokens = compilationInfo.getTokenHierarchy();
        TokenSequence ts = tokens.tokenSequence();
        boolean inJavadoc = false;
        int offset = ts.move(lastPosition);
        if (ts.moveNext() && ts.token() != null) {
            Token token = ts.token();
            TokenId tid = token.id();
            if (tid == JavaTokenId.JAVADOC_COMMENT) {
                inJavadoc = true;
            }
            if (tid == JavaTokenId.WHITESPACE && this.shouldGoBack(token.text().toString(), offset < 0 ? 0 : offset) && ts.movePrevious()) {
                token = ts.token();
                tid = token.id();
            }
            if (TOKENS_TO_SKIP.contains(tid)) {
                this.skipTokens(ts, TOKENS_TO_SKIP);
            }
            lastPosition = ts.offset();
        }
        if (ts.token() != null && (ts.token().length() > 1 || ts.token().id() == JavaTokenId.AT)) {
            ++lastPosition;
        }
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)(k = (tp = compilationInfo.getTreeUtilities().pathFor(lastPosition)).getLeaf().getKind())) && ts.token() != null && ts.token().length() == 1) {
            TreePath tp2 = compilationInfo.getTreeUtilities().pathFor(lastPosition + 1);
            SourcePositions sp = compilationInfo.getTrees().getSourcePositions();
            long e1 = sp.getEndPosition(compilationInfo.getCompilationUnit(), tp2.getLeaf());
            long e2 = sp.getEndPosition(compilationInfo.getCompilationUnit(), tp.getLeaf());
            if (e2 != -1L && e1 != -1L && e1 <= e2) {
                for (TreePath p = tp2; p != null && p.getLeaf() != tp.getLeaf() && p.getParentPath() != null; p = p.getParentPath()) {
                    if (p.getParentPath().getLeaf() != tp.getLeaf()) continue;
                    tp = tp2;
                    break;
                }
            }
        }
        if (this.isCancelled()) {
            return;
        }
        if (navigatorShouldUpdate) {
            this.updateNavigatorSelection(compilationInfo, tp);
        }
        Element element = compilationInfo.getTrees().getElement(tp);
        if (this.isCancelled()) {
            return;
        }
        if (element == null || inJavadoc) {
            Pair<Element, TreePath> p = CaretListeningTask.outerElement(compilationInfo, tp);
            Element element2 = element = p != null ? (Element)p.first() : null;
        }
        if (this.isCancelled() || element == null) {
            return;
        }
        if (Utils.signatureEquals(lastEh, element) && !inJavadoc) {
            return;
        }
        switch (element.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case RECORD: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ENUM_CONSTANT: 
            case MODULE: {
                lastEh = Utils.createElementHandle(element);
                this.setJavadoc(null, null);
                break;
            }
            case TYPE_PARAMETER: 
            case PARAMETER: {
                element = element.getEnclosingElement();
                lastEh = element != null && element.asType() != null ? Utils.createElementHandle(element) : null;
                this.setJavadoc(null, null);
                break;
            }
            case LOCAL_VARIABLE: {
                lastEh = null;
                this.setJavadoc(null, null);
                return;
            }
            default: {
                this.setJavadoc(null, null);
                return;
            }
        }
        if (javadocShouldUpdate) {
            this.computeAndSetJavadoc(compilationInfo, element);
        }
        if (this.isCancelled()) {
            return;
        }
    }

    private void setJavadoc(final FileObject owner, final ElementJavadoc javadoc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavadocTopComponent javadocTopComponent = JavadocTopComponent.findInstance();
                if (javadocTopComponent != null && javadocTopComponent.isOpened()) {
                    javadocTopComponent.setJavadoc(owner, javadoc);
                }
            }
        });
    }

    public final void cancel() {
        this.canceled.set(true);
    }

    protected final boolean isCancelled() {
        return this.canceled.get();
    }

    protected final void resume() {
        this.canceled.set(false);
    }

    private void computeAndSetJavadoc(CompilationInfo compilationInfo, Element element) {
        if (this.isCancelled()) {
            return;
        }
        this.setJavadoc(compilationInfo.getFileObject(), ElementJavadoc.create((CompilationInfo)compilationInfo, (Element)element, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CaretListeningTask.this.isCancelled();
            }
        }));
    }

    private void updateNavigatorSelection(CompilationInfo ci, TreePath tp) throws Exception {
        Pair<Element, TreePath> p;
        ClassMemberPanel cmp = ClassMemberPanel.getInstance();
        if (cmp == null) {
            return;
        }
        ClassMemberPanelUI cmpUi = cmp.getClassMemberPanelUI();
        if (!cmpUi.isAutomaticRefresh()) {
            cmpUi.getTask().runImpl(ci, false);
            lastEhForNavigator = null;
        }
        if ((p = CaretListeningTask.outerElement(ci, tp)) != null) {
            Element e = (Element)p.first();
            Runnable action = null;
            if (e == null) {
                lastEhForNavigator = null;
                action = () -> cmp.selectTreePath(TreePathHandle.create((TreePath)((TreePath)p.second()), (CompilationInfo)ci));
            } else if (e.getKind() != ElementKind.OTHER) {
                ElementHandle eh = ElementHandle.create((Element)e);
                if (lastEhForNavigator != null && eh.signatureEquals(lastEhForNavigator)) {
                    return;
                }
                lastEhForNavigator = eh;
                action = () -> cmp.selectElement((ElementHandle<Element>)eh);
            }
            if (action != null) {
                SwingUtilities.invokeLater(action);
            }
        }
    }

    private static Pair<Element, TreePath> outerElement(CompilationInfo ci, TreePath tp) {
        Pair res = null;
        while (tp != null) {
            switch (tp.getLeaf().getKind()) {
                case METHOD: 
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case COMPILATION_UNIT: 
                case MODULE: {
                    Element e = ci.getTrees().getElement(tp);
                    if (e == null) break;
                    res = Pair.of((Object)e, (Object)tp);
                    break;
                }
                case REQUIRES: 
                case EXPORTS: 
                case OPENS: 
                case PROVIDES: 
                case USES: {
                    res = Pair.of(null, (Object)tp);
                    break;
                }
                case VARIABLE: {
                    Element e = ci.getTrees().getElement(tp);
                    if (e == null || !e.getKind().isField()) break;
                    res = Pair.of((Object)e, (Object)tp);
                    break;
                }
            }
            if (res != null) break;
            tp = tp.getParentPath();
        }
        return res;
    }

    private void skipTokens(TokenSequence ts, Set<JavaTokenId> typesToSkip) {
        while (ts.moveNext()) {
            if (typesToSkip.contains(ts.token().id())) continue;
            return;
        }
    }

    private boolean shouldGoBack(String s, int offset) {
        int nlBefore = 0;
        int nlAfter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            if (i < offset) {
                ++nlBefore;
            } else {
                ++nlAfter;
            }
            if (nlAfter <= nlBefore) continue;
            return true;
        }
        if (nlBefore < nlAfter) {
            return false;
        }
        return offset < s.length() - offset;
    }

    static {
        TOKENS_TO_SKIP = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }
}

