/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.URLUtils;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPv4Address
extends Host {
    private static final long serialVersionUID = 1L;
    private final int address;

    private IPv4Address(byte[] addr) {
        int address = 0;
        address = addr[3] & 0xFF;
        address |= addr[2] << 8 & 0xFF00;
        address |= addr[1] << 16 & 0xFF0000;
        this.address = address |= addr[0] << 24 & 0xFF000000;
    }

    public static IPv4Address parseIPv4Address(String input) throws GalimatiasParseException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (input.isEmpty()) {
            throw new GalimatiasParseException("empty input");
        }
        byte[] addr = new byte[4];
        int dotsSeen = 0;
        int addrIdx = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int value = 0;
            while (URLUtils.isASCIIDigit(c)) {
                value = value * 10 + (c - 48);
                c = ++i >= input.length() ? (char)'\u0000' : input.charAt(i);
            }
            if (value > 255) {
                throw new GalimatiasParseException("Malformed IPv4 address, bad value: " + value);
            }
            if (dotsSeen < 3 && c != '.') {
                throw new GalimatiasParseException("Malformed IPv4 address", i);
            }
            if (dotsSeen == 3 && i < input.length()) {
                throw new GalimatiasParseException("IPv4 address is too long", i);
            }
            addr[addrIdx] = (byte)value;
            ++addrIdx;
            ++dotsSeen;
        }
        if (dotsSeen != 4) {
            throw new GalimatiasParseException("Malformed IPv4 address");
        }
        return new IPv4Address(addr);
    }

    public Inet4Address toInetAddress() throws UnknownHostException {
        return (Inet4Address)Inet4Address.getByAddress(this.getBytes());
    }

    private byte[] getBytes() {
        return new byte[]{(byte)(this.address >> 24 & 0xFF), (byte)(this.address >> 16 & 0xFF), (byte)(this.address >> 8 & 0xFF), (byte)(this.address & 0xFF)};
    }

    @Override
    public String toString() {
        byte[] bytes = this.getBytes();
        return String.format("%d.%d.%d.%d", bytes[0] & 0xFF, bytes[1] & 0xFF, bytes[2] & 0xFF, bytes[3] & 0xFF);
    }

    @Override
    public String toHumanString() {
        return this.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPv4Address)) {
            return false;
        }
        return this.address == ((IPv4Address)obj).address;
    }

    public int hashCode() {
        return this.address;
    }
}

