/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javaee.injection.api.InjectionTargetQuery;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.PolicyManager;
import org.openide.filesystems.FileObject;

class CompilerTask
implements CancellableTask<CompilationController> {
    private final boolean[] insertServiceDef = new boolean[]{true};
    private final boolean[] generateWsRefInjection = new boolean[]{false};
    private final String[] printerName = new String[]{"System.out"};
    private final String serviceJavaName;
    private final String[] serviceFName;
    private final String[] argumentDeclPart;
    private final String[] paramNames;
    private final String[] argumentInitPart;
    private final PolicyManager manager;

    public CompilerTask(String serviceJavaName, String[] serviceFName, String[] argumentDeclPart, String[] paramNames, String[] argumentInitPart, PolicyManager manager) {
        this.serviceJavaName = serviceJavaName;
        this.argumentInitPart = argumentInitPart;
        this.argumentDeclPart = argumentDeclPart;
        this.paramNames = paramNames;
        this.serviceFName = serviceFName;
        this.manager = manager;
    }

    public void run(CompilationController controller) throws IOException {
        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        CompilationUnitTree cut = controller.getCompilationUnit();
        TypeElement thisTypeEl = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
        if (thisTypeEl != null) {
            ClassTree javaClass = controller.getTrees().getTree(thisTypeEl);
            this.generateWsRefInjection[0] = InjectionTargetQuery.isInjectionTarget((CompilationController)controller, (TypeElement)thisTypeEl);
            if (this.generateWsRefInjection[0]) {
                Project project = FileOwnerQuery.getOwner((FileObject)controller.getFileObject());
                this.generateWsRefInjection[0] = JaxWsUtils.isEjbSupported(project);
            }
            boolean bl = this.insertServiceDef[0] = !this.generateWsRefInjection[0];
            if (CompilerTask.isServletClass(controller, thisTypeEl)) {
                this.printerName[0] = "out";
                this.argumentInitPart[0] = CompilerTask.fixNamesInInitializationPart(this.argumentInitPart[0]);
                this.argumentDeclPart[0] = CompilerTask.fixNamesInDeclarationPart(this.argumentDeclPart[0]);
                CompilerTask.fixNamesMethodParams(this.paramNames);
            }
            if (this.generateWsRefInjection[0]) {
                HashSet<String> serviceFieldNames = new HashSet<String>();
                boolean injectionExists = false;
                int memberOrder = 0;
                for (Tree tree : javaClass.getMembers()) {
                    String variableType;
                    ++memberOrder;
                    if (Tree.Kind.VARIABLE != tree.getKind()) continue;
                    VariableTree var = (VariableTree)tree;
                    Tree typeTree = var.getType();
                    TreePath typeTreePath = controller.getTrees().getPath(cut, typeTree);
                    TypeElement typeEl = (TypeElement)controller.getTrees().getElement(typeTreePath);
                    if (typeEl != null && this.serviceJavaName.equals(variableType = typeEl.getQualifiedName().toString())) {
                        this.serviceFName[0] = var.getName().toString();
                        this.generateWsRefInjection[0] = false;
                        injectionExists = true;
                        break;
                    }
                    serviceFieldNames.add(var.getName().toString());
                }
                if (!injectionExists) {
                    this.serviceFName[0] = CompilerTask.findProperServiceFieldName(serviceFieldNames);
                }
            }
        }
    }

    public void cancel() {
    }

    public String getMethodBody(String portJavaName, String portGetterMethod, String returnTypeName, String operationJavaName) {
        String methodBody = "";
        Object[] args = this.getMethodBodyPortInitArguments(portJavaName, portGetterMethod, returnTypeName, operationJavaName);
        if ("void".equals(returnTypeName)) {
            String body = (this.insertServiceDef[0] ? "   {0} {7} = new {0}();\n" : "") + "   {1} port = {7}.{2}({9});\n" + "   {3}   port.{5}({6});\n";
            methodBody = MessageFormat.format(body, args);
        } else {
            String body = (this.insertServiceDef[0] ? "   {0} {7} = new {0}();\n" : "") + "   {1} port = {7}.{2}({9});\n" + "   {3}   return port.{5}({6});\n";
            methodBody = MessageFormat.format(body, args);
        }
        return methodBody;
    }

    public String getJavaInvocationBody(WsdlOperation operation, String portJavaName, String portGetterMethod, String returnTypeName, String operationJavaName, String responseType) {
        String invocationBody = "";
        Object[] args = this.getInvocationBodyPortInitArguments(portJavaName, portGetterMethod, returnTypeName, operationJavaName);
        switch (operation.getOperationType()) {
            case 0: {
                if ("void".equals(returnTypeName)) {
                    String body = "\ntry '{' // Call Web Service Operation\n" + (this.insertServiceDef[0] ? "   {0} {7} = new {0}();\n" : "") + "   {1} port = {7}.{2}({9});\n" + "   {3}   port.{5}({6});\n" + "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
                    invocationBody = MessageFormat.format(body, args);
                    break;
                }
                String body = "\ntry '{' // Call Web Service Operation\n" + (this.insertServiceDef[0] ? "   {0} {7} = new {0}();\n" : "") + "   {1} port = {7}.{2}({9});\n" + "   {3}   // TODO process result here\n   {4} result = port.{5}({6});\n" + "   {8}.println(\"Result = \"+result);\n" + "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
                invocationBody = MessageFormat.format(body, args);
                break;
            }
            case 1: {
                invocationBody = MessageFormat.format("\ntry '{' // Call Web Service Operation(async. polling)\n   {0} service = new {0}();\n   {1} port = service.{2}({9});\n   {3}   // TODO process asynchronous response here\n   {4} resp = port.{5}({6});\n   while(!resp.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n   System.out.println(\"Result = \"+resp.get());\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n", args);
                break;
            }
            case 2: {
                args[7] = responseType;
                invocationBody = MessageFormat.format("\ntry '{' // Call Web Service Operation(async. callback)\n   {0} service = new {0}();\n   {1} port = service.{2}({9});\n   {3}       public void handleResponse(javax.xml.ws.Response<{7}> response) '{'\n           try '{'\n               // TODO process asynchronous response here\n               System.out.println(\"Result = \"+ response.get());\n           '}' catch(Exception ex) '{'\n               // TODO handle exception\n           '}'\n       '}'\n   '}';\n   {4} result = port.{5}({6});\n   while(!result.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n", args);
                break;
            }
        }
        return invocationBody;
    }

    public boolean containsWsRefInjection() {
        return !this.generateWsRefInjection[0];
    }

    public boolean isWsRefInjection() {
        return !this.insertServiceDef[0];
    }

    protected Object[] getMethodBodyPortInitArguments(String portJavaName, String portGetterMethod, String returnTypeName, String operationJavaName) {
        Object[] result = new Object[]{this.serviceJavaName, portJavaName, portGetterMethod, "", "", operationJavaName, this.argumentDeclPart[0], this.serviceFName[0], "", ""};
        if (this.manager.isSupported()) {
            this.manager.modifyPortCallInitArguments(result);
        }
        return result;
    }

    protected Object[] getInvocationBodyPortInitArguments(String portJavaName, String portGetterMethod, String returnTypeName, String operationJavaName) {
        Object[] result = new Object[]{this.serviceJavaName, portJavaName, portGetterMethod, this.argumentInitPart[0], returnTypeName, operationJavaName, this.argumentDeclPart[0], this.serviceFName[0], this.printerName[0], ""};
        if (this.manager.isSupported()) {
            this.manager.modifyPortInvocationInitArguments(result);
        }
        return result;
    }

    private static boolean isServletClass(CompilationController controller, TypeElement typeElement) {
        return SourceUtils.isSubtype((CompilationController)controller, (TypeElement)typeElement, (String)"javax.servlet.http.HttpServlet");
    }

    private static String fixNamesInInitializationPart(String argumentInitializationPart) {
        return argumentInitializationPart.replaceFirst(" request ", " request_1 ").replaceFirst(" response ", " response_1 ").replaceFirst(" out ", " out_1 ");
    }

    private static void fixNamesMethodParams(String[] params) {
        for (int i = 0; i < params.length; ++i) {
            if ("request".equals(params[i])) {
                params[i] = "request_1";
                continue;
            }
            if ("response".equals(params[i])) {
                params[i] = "response_1";
                continue;
            }
            if (!"out".equals(params[i])) continue;
            params[i] = "out_1";
        }
    }

    private static String fixNamesInDeclarationPart(String argumentDeclarationPart) {
        StringTokenizer tok = new StringTokenizer(argumentDeclarationPart, " ,");
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            String newName = null;
            newName = "request".equals(token) ? "request_1" : ("response".equals(token) ? "response_1" : ("out".equals(token) ? "out_1" : token));
            buf.append(i > 0 ? ", " + newName : newName);
            ++i;
        }
        return buf.toString();
    }

    private static String findProperServiceFieldName(Set serviceFieldNames) {
        String name = "service";
        int i = 0;
        while (serviceFieldNames.contains(name)) {
            name = "service_" + String.valueOf(++i);
        }
        return name;
    }
}

