/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRIncrementer;

class JRDoubleVarianceIncrementer
implements JRIncrementer {
    private static JRDoubleVarianceIncrementer mainInstance = new JRDoubleVarianceIncrementer();

    private JRDoubleVarianceIncrementer() {
    }

    public static JRDoubleVarianceIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRFillVariable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            return JRDoubleIncrementerFactory.ZERO;
        }
        Number countValue = (Number)valueProvider.getValue(variable.getHelperVariable((byte)0));
        Number sumValue = (Number)valueProvider.getValue(variable.getHelperVariable((byte)1));
        return new Double((countValue.doubleValue() - 1.0) * value.doubleValue() / countValue.doubleValue() + (sumValue.doubleValue() / countValue.doubleValue() - newValue.doubleValue()) * (sumValue.doubleValue() / countValue.doubleValue() - newValue.doubleValue()) / (countValue.doubleValue() - 1.0));
    }
}

