/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.Color;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.cookies.ViewCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.context.ContextChangeCookie;
import tr.model.project.Project;
import tr.model.project.ProjectSingleActions;
import tr.model.project.Sequencing;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.prefs.projects.ProjectsPrefs;
import tr.util.HTML;
import tr.util.Observable;
import tr.view.DeleteAction;
import tr.view.DeleteCookie;
import tr.view.ReprocessAction;
import tr.view.ReprocessCookie;
import tr.view.WindowUtils;
import tr.view.contexts.ContextChangeAction;
import tr.view.process.ProcessThoughtsAction;
import tr.view.projects.ActionFinder;
import tr.view.projects.AddActionAction;
import tr.view.projects.AddActionCookie;
import tr.view.projects.AddProjectAction;
import tr.view.projects.AddProjectCookie;
import tr.view.projects.EditAction;
import tr.view.projects.EditCookie;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.PostponeActionAction;
import tr.view.projects.PostponeActionCookie;
import tr.view.projects.PrintAction;
import tr.view.projects.PrintCookie;
import tr.view.projects.ProjectNode;
import tr.view.projects.ProjectiseAction;
import tr.view.projects.ProjectiseCookie;
import tr.view.projects.ProjectsTreeTopComponent;
import tr.view.projects.ReportImpl;
import tr.view.projects.SetDoneAction;
import tr.view.projects.SetDoneCookie;
import tr.view.projects.TransferNode;
import tr.view.topics.TopicChangeAction;

public class ActionNode
extends AbstractNode
implements EditCookie,
ProjectiseCookie,
ReprocessCookie,
ActionFinder,
TransferNode,
AddActionCookie,
AddProjectCookie,
ViewCookie,
PrintCookie,
SetDoneCookie,
PostponeActionCookie,
DeleteCookie {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    public final Action action;
    private IconChangeListener icl;
    private NameChangeListener ncl;
    private boolean showDone;
    private int transferType;

    public ActionNode(Action action) {
        super(Children.LEAF, Lookups.singleton((Object)action));
        this.action = action;
        this.addListeners();
    }

    private void addListeners() {
        this.icl = new IconChangeListener();
        this.action.addPropertyChangeListenter("State", (PropertyChangeListener)this.icl);
        this.ncl = new NameChangeListener();
        this.action.addPropertyChangeListenter("Done", (PropertyChangeListener)this.ncl);
        this.action.addPropertyChangeListenter("Descr", (PropertyChangeListener)this.ncl);
        this.action.addPropertyChangeListenter("Topic", (PropertyChangeListener)this.ncl);
    }

    private void removeListeners() {
        this.action.removePropertyChangeListenter("State", (PropertyChangeListener)this.icl);
        this.icl = null;
        this.action.removePropertyChangeListenter("Done", (PropertyChangeListener)this.ncl);
        this.action.removePropertyChangeListenter("Descr", (PropertyChangeListener)this.ncl);
        this.action.removePropertyChangeListenter("Topic", (PropertyChangeListener)this.ncl);
        this.ncl = null;
    }

    public boolean isHidden() {
        return !this.showDone && this.action.isDone();
    }

    public void setShowDone(boolean showDone) {
        this.showDone = showDone;
        this.fireCookieChange();
    }

    public String getName() {
        return this.action.getDescription();
    }

    public String toString() {
        return this.action.getDescription();
    }

    public void setName(String name) {
        super.setName(name);
    }

    private String escapeHTML(String str) {
        str = StringEscapeUtils.escapeXml((String)str);
        return str.replace("&apos;", "'");
    }

    public String getHtmlDisplayName() {
        String color;
        String name = this.escapeHTML(this.getName());
        String string = color = this.action.isStateInactive() ? HTML.format((Color)Color.GRAY) : HTML.format((Color)this.action.getTopic().getForeground());
        if (this.action.isDone()) {
            return "<s><font color='" + color + "'>" + name + "</font></s>";
        }
        return "<font color='" + color + "'>" + name + "</font>";
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        this.action.removeFromParent();
    }

    public boolean canRename() {
        return false;
    }

    public javax.swing.Action[] getActions(boolean popup) {
        if (this.action.isSingleAction()) {
            return new javax.swing.Action[]{SystemAction.get(EditAction.class), null, SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(ReprocessAction.class), SystemAction.get(ProjectiseAction.class), null, SystemAction.get(ContextChangeAction.class), SystemAction.get(TopicChangeAction.class), null, SystemAction.get(AddActionAction.class), null, SystemAction.get(PostponeActionAction.class), SystemAction.get(SetDoneAction.class), null, SystemAction.get(PrintAction.class)};
        }
        return new javax.swing.Action[]{SystemAction.get(EditAction.class), null, SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(ReprocessAction.class), SystemAction.get(ProjectiseAction.class), null, SystemAction.get(ContextChangeAction.class), SystemAction.get(TopicChangeAction.class), null, SystemAction.get(AddActionAction.class), SystemAction.get(AddProjectAction.class), null, SystemAction.get(PostponeActionAction.class), SystemAction.get(SetDoneAction.class), null, SystemAction.get(PrintAction.class)};
    }

    public javax.swing.Action getPreferredAction() {
        return SystemAction.get(EditAction.class);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == ViewCookie.class) {
            return this;
        }
        if (clazz == DeleteCookie.class) {
            return this;
        }
        if (clazz == EditCookie.class) {
            return this;
        }
        if (clazz == AddActionCookie.class) {
            return this;
        }
        if (clazz == AddProjectCookie.class) {
            return this;
        }
        if (clazz == ReprocessCookie.class) {
            return this;
        }
        if (clazz == ProjectiseCookie.class) {
            return this;
        }
        if (clazz == PrintCookie.class) {
            return this;
        }
        if (clazz == TopicChangeCookie.class) {
            return this.action;
        }
        if (clazz == ContextChangeCookie.class) {
            return this.action;
        }
        if (clazz == SetDoneCookie.class) {
            return this;
        }
        if (clazz == PostponeActionCookie.class) {
            return this;
        }
        return super.getCookie(clazz);
    }

    public Image getIcon(int type) {
        ImageIcon icon = this.action.getIcon(false);
        if (icon instanceof ImageIcon) {
            return icon.getImage();
        }
        return super.getIcon(type);
    }

    public void reprocess(boolean now) {
        if (this.action == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        ProcessThoughtsAction processThoughtsAction = null;
        if (now && (processThoughtsAction = (ProcessThoughtsAction)SystemAction.get(ProcessThoughtsAction.class)) != null) {
            WindowUtils.closeWindows();
        }
        this.removeListeners();
        this.action.removeFromParent();
        this.fireNodeDestroyed();
        Thought thought = new Thought(data.getNextID());
        thought.setDescription(this.action.getDescription());
        thought.setTopic(this.action.getTopic());
        thought.setAction(this.action);
        data.getThoughtManager().insert((Observable)thought, 0);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (now && processThoughtsAction != null) {
            processThoughtsAction.performAction();
        }
    }

    public void projectise() {
        if (this.action == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Node parentNode = this.getParentNode();
        Project parent = (Project)this.action.getParent();
        int index = parent.indexOf((Item)this.action);
        this.removeListeners();
        this.action.removeFromParent();
        this.fireNodeDestroyed();
        Project project = new Project((IDGenerator)data);
        project.setThought(this.action.getThought());
        project.setDescription(this.action.getDescription());
        project.setTopic(this.action.getTopic());
        project.setPriority(this.action.getPriority());
        project.setDueDate(this.action.getDueDate());
        project.setNotes(this.action.getNotes());
        if (parent.isRoot()) {
            if (ProjectsPrefs.isSequencing()) {
                project.setSequencing(true);
                project.setSequenceType(Sequencing.INTO_SUBPROJECTS);
            }
        } else {
            project.setSequencing(parent.isSequencing());
            project.setSequenceType(parent.getSequenceType());
        }
        project.add((Item)this.action);
        if (parent instanceof ProjectSingleActions) {
            data.getRootProjects().add((Item)project);
            ProjectsTreeTopComponent pt = ProjectsTreeTopComponent.getDefault();
            if (!pt.isOpened()) {
                WindowManager wm = WindowManager.getDefault();
                pt = (ProjectsTreeTopComponent)wm.findTopComponent("RAProjectsTopComponent");
            }
            if (pt != null && pt.isOpened()) {
                pt.requestActive();
                Node rootNode = pt.getExplorerManager().getRootContext();
                if (rootNode instanceof ProjectNode) {
                    ((ProjectNode)rootNode).select(project);
                }
            }
        } else {
            parent.add(index, (Item)project);
            if (parentNode instanceof ProjectNode) {
                ((ProjectNode)parentNode).select(project);
            }
        }
    }

    public Node find(Action findAction) {
        return this.action.getID() == findAction.getID() ? this : null;
    }

    public Transferable clipboardCut() throws IOException {
        this.setTransferType(2);
        return super.clipboardCut();
    }

    public Transferable clipboardCopy() throws IOException {
        this.setTransferType(1);
        return super.clipboardCopy();
    }

    public void setTransferType(int type) {
        this.transferType = type;
    }

    public boolean isMoveTransfer() {
        return (this.transferType & 2) != 0;
    }

    public boolean isCopyTransfer() {
        return (this.transferType & 1) != 0;
    }

    public void edit() {
        EditorTopComponent.findInstance().edit(this);
    }

    public void changeTopic(Topic topic) {
        this.action.setTopic(topic);
    }

    public void changeContext(Context context) {
        this.action.setContext(context);
    }

    public void addAction() {
        Node parentNode = this.getParentNode();
        if (parentNode instanceof AddActionCookie) {
            ((AddActionCookie)parentNode).addAction(this.action);
        }
    }

    public void addAction(Action sibling) {
    }

    public void addProject() {
        Node parentNode = this.getParentNode();
        if (parentNode instanceof AddProjectCookie) {
            ((AddProjectCookie)parentNode).addProject(this.action);
        }
    }

    public void addProject(Action sibling) {
    }

    public boolean canAddAction() {
        Node parentNode = this.getParentNode();
        if (parentNode instanceof AddActionCookie) {
            return ((AddActionCookie)parentNode).canAddAction();
        }
        return false;
    }

    public boolean canAddProject() {
        Node parentNode = this.getParentNode();
        if (parentNode instanceof AddActionCookie) {
            return ((AddProjectCookie)parentNode).canAddProject();
        }
        return false;
    }

    public void view() {
        EditorTopComponent.findInstance().view((Node)this);
    }

    public void print() {
        try {
            ReportImpl report = new ReportImpl();
            report.process(this.action);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDone() {
        if (this.action != null) {
            this.action.setDone(true);
        }
    }

    private Date add(Date date, int n, PostponeActionAction.Periods periods) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        switch (periods) {
            case DAYS: {
                calendar.add(6, n);
                break;
            }
            case WEEKS: {
                calendar.add(3, n);
                break;
            }
            case MONTHS: {
                calendar.add(2, n);
                break;
            }
            case YEARS: {
                calendar.add(1, n);
            }
        }
        return calendar.getTime();
    }

    public void postponeAction(int n, PostponeActionAction.Periods periods) {
        switch (this.action.getState().getType()) {
            case DOASAP: {
                this.action.setDueDate(this.add(this.action.getDueDate(), n, periods));
                break;
            }
            case INACTIVE: {
                this.action.setStartDate(this.add(this.action.getStartDate(), n, periods));
                break;
            }
            case SCHEDULED: {
                ActionStateScheduled state = (ActionStateScheduled)this.action.getState();
                state.setDate(this.add(state.getDate(), n, periods));
                break;
            }
            case DELEGATED: {
                ActionStateDelegated state = (ActionStateDelegated)this.action.getState();
                state.setDate(this.add(state.getDate(), n, periods));
                break;
            }
        }
    }

    public void delete() {
        this.action.removeFromParent();
    }

    private class NameChangeListener
    implements PropertyChangeListener {
        private NameChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ActionNode.this.setName(ActionNode.this.action.getDescription());
        }
    }

    private class IconChangeListener
    implements PropertyChangeListener {
        private IconChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ActionNode.this.setName(ActionNode.this.action.getDescription());
            ActionNode.this.fireIconChange();
        }
    }
}

