/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.zaproxy.zap.extension.api.ApiParameter;

public class ApiElement {
    private String name = null;
    private String descriptionTag = "";
    private List<ApiParameter> parameters = new ArrayList<ApiParameter>();
    private boolean deprecated;
    private String deprecatedDescription;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiElement(String name) {
        this.name = name;
    }

    public ApiElement(String name, List<String> mandatoryParamNames) {
        this(name, mandatoryParamNames, null);
    }

    public ApiElement(String name, List<String> mandatoryParamNames, List<String> optionalParamNames) {
        this.name = name;
        this.addParameters(mandatoryParamNames, true);
        this.addParameters(optionalParamNames, false);
    }

    public ApiElement(String name, String[] mandatoryParamNames) {
        this(name, mandatoryParamNames, null);
    }

    public ApiElement(String name, String[] mandatoryParamNames, String[] optionalParamNames) {
        this(name, ApiElement.asList(mandatoryParamNames), ApiElement.asList(optionalParamNames));
    }

    private static List<String> asList(String[] elements) {
        return elements != null ? Arrays.asList(elements) : null;
    }

    public void setMandatoryParamNames(String[] paramNames) {
        this.setMandatoryParamNames(ApiElement.asList(paramNames));
    }

    public void setMandatoryParamNames(List<String> paramNames) {
        this.parameters.removeIf(ApiParameter::isRequired);
        if (paramNames != null) {
            List<ApiParameter> optionalParameters = this.parameters;
            this.parameters = new ArrayList<ApiParameter>(optionalParameters.size() + paramNames.size());
            this.addParameters(paramNames, true);
            this.parameters.addAll(optionalParameters);
        }
    }

    private void addParameters(List<String> names, boolean required) {
        if (names == null) {
            return;
        }
        names.forEach(param -> this.parameters.add(new ApiParameter((String)param, "", required)));
    }

    public List<String> getMandatoryParamNames() {
        return this.getParametersNames(ApiParameter::isRequired);
    }

    private List<String> getParametersNames(Predicate<ApiParameter> predicate) {
        return this.parameters.stream().filter(predicate).map(ApiParameter::getName).collect(Collectors.toList());
    }

    public String getDescriptionTag() {
        return this.descriptionTag;
    }

    public void setDescriptionTag(String descriptionTag) {
        this.descriptionTag = descriptionTag == null ? "" : descriptionTag;
    }

    public List<String> getOptionalParamNames() {
        return this.getParametersNames(e -> !e.isRequired());
    }

    public void setOptionalParamNames(String[] optionalParamNames) {
        this.setOptionalParamNames(ApiElement.asList(optionalParamNames));
    }

    public void setOptionalParamNames(List<String> optionalParamNames) {
        this.parameters.removeIf(e -> !e.isRequired());
        this.addParameters(optionalParamNames, false);
    }

    public List<ApiParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecatedDescription() {
        return this.deprecatedDescription;
    }

    public void setDeprecatedDescription(String description) {
        this.deprecatedDescription = description;
    }
}

