function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
import React, { useCallback, useEffect, useMemo, useState } from 'react';
import classNames from 'classnames';
import { OuiScreenReaderOnly } from '../accessibility';
import { OuiSplitButtonControl } from './split_button_control';
import { OuiPopover } from '../popover';
import { OuiContextMenuItem } from '../context_menu';
import { cascadingMenuKeys, keys } from '../../services';
import { OuiI18n } from '../i18n';
import { OuiText } from '../text';
import { OuiFocusTrap } from '../focus_trap';
import { tabbable } from 'tabbable';
var ShiftDirection;

(function (ShiftDirection) {
  ShiftDirection["BACK"] = "back";
  ShiftDirection["FORWARD"] = "forward";
})(ShiftDirection || (ShiftDirection = {}));

export var OuiSplitButton = function OuiSplitButton(_ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'primary' : _ref$color,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      disabled = _ref.disabled,
      _ref$options = _ref.options,
      options = _ref$options === void 0 ? [] : _ref$options,
      selectedIndex = _ref.selectedIndex,
      _ref$initiallyOpen = _ref.initiallyOpen,
      initiallyOpen = _ref$initiallyOpen === void 0 ? false : _ref$initiallyOpen,
      hasDividers = _ref.hasDividers,
      itemClassName = _ref.itemClassName,
      onClick = _ref.onClick,
      className = _ref.className,
      popoverClassName = _ref.popoverClassName,
      children = _ref.children,
      dropdownProps = _ref.dropdownProps,
      optionProps = _ref.optionProps,
      buttonProps = _ref.buttonProps,
      rest = _objectWithoutProperties(_ref, ["color", "fullWidth", "disabled", "options", "selectedIndex", "initiallyOpen", "hasDividers", "itemClassName", "onClick", "className", "popoverClassName", "children", "dropdownProps", "optionProps", "buttonProps"]);

  var itemNodes = useMemo(function () {
    return [];
  }, []);

  var _useState = useState(!!initiallyOpen),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var _useState3 = useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      panelEl = _useState4[0],
      setPanelEl = _useState4[1];

  var panelRef = function panelRef(node) {
    return setPanelEl(node);
  };

  var onKeyDown = function onKeyDown(event) {
    if (panelEl && event.key === cascadingMenuKeys.TAB) {
      var tabbableItems = tabbable(panelEl).filter(function (el) {
        return Array.from(el.attributes).map(function (el) {
          return el.name;
        }).indexOf('data-focus-guard') < 0;
      });

      if (tabbableItems.length && tabbableItems[tabbableItems.length - 1] === document.activeElement) {
        setIsOpen(false);
      }
    }
  };

  var focusItemAt = useCallback(function (index) {
    var targetElement = itemNodes[index];

    if (targetElement != null) {
      targetElement.focus();
      return targetElement.matches(':focus');
    }
  }, [itemNodes]);
  var focusSelected = useCallback(function () {
    requestAnimationFrame(function () {
      var hasFocus = focusItemAt(selectedIndex || 0);

      if (!hasFocus) {
        focusSelected();
      }
    });
  }, [selectedIndex, focusItemAt]);
  useEffect(function () {
    isOpen && requestAnimationFrame(focusSelected);
  }, [isOpen, focusSelected]);

  var onSelectKeyDown = function onSelectKeyDown(event) {
    if (event.key === keys.ARROW_UP || event.key === keys.ARROW_DOWN) {
      event.preventDefault();
      event.stopPropagation();
      setIsOpen(true);
    }
  };

  var shiftFocus = function shiftFocus(direction) {
    var currentIndex = itemNodes.indexOf(document.activeElement);
    setIsOpen(true);

    if (currentIndex === -1) {
      // somehow the select options has lost focus
      focusItemAt(0);
    } else {
      if (direction === ShiftDirection.BACK) {
        focusItemAt(currentIndex === 0 ? itemNodes.length - 1 : currentIndex - 1);
      } else {
        focusItemAt(currentIndex === itemNodes.length - 1 ? 0 : currentIndex + 1);
      }
    }
  };

  var onItemKeyDown = function onItemKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      // close the popover and prevent ancestors from handling
      event.preventDefault();
      event.stopPropagation();
      setIsOpen(false);
    } else if (event.key === keys.TAB) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.FORWARD);
    } else if (event.key === keys.TAB && event.shiftKey) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.BACK);
    } else if (event.key === keys.ARROW_UP) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.BACK);
    } else if (event.key === keys.ARROW_DOWN) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.FORWARD);
    }
  };

  var popoverClasses = classNames('ouiSplitButton', popoverClassName);
  var buttonClasses = classNames({
    'ouiSplitButton--isOpen__button': isOpen
  }, className);
  var itemClasses = classNames('ouiSplitButton__item', {
    'ouiSplitButton__item--hasDividers': hasDividers
  }, itemClassName);

  var onPrimaryClick = function onPrimaryClick() {
    onClick === null || onClick === void 0 ? void 0 : onClick();
    setIsOpen(false);
  };

  var button = /*#__PURE__*/React.createElement(OuiSplitButtonControl, _extends({
    color: color,
    onDropdownClick: function onDropdownClick() {
      return setIsOpen(!isOpen);
    },
    onClick: onPrimaryClick,
    onKeyDown: onSelectKeyDown,
    className: buttonClasses,
    fullWidth: fullWidth,
    dropdownProps: dropdownProps,
    buttonProps: buttonProps,
    disabled: disabled
  }, rest), children);

  var itemIcon = function itemIcon(index) {
    if (selectedIndex === undefined) return;
    if (selectedIndex === index) return 'check';
    return 'empty';
  };

  var items = options.map(function (option, index) {
    var isSelected = selectedIndex === index;
    var content = typeof option.display === 'string' ? /*#__PURE__*/React.createElement(OuiText, _extends({
      textAlign: "center"
    }, optionProps), option.display) : option.display;

    var itemOnClick = function itemOnClick() {
      var _option$onClick;

      setIsOpen(false);
      (_option$onClick = option.onClick) === null || _option$onClick === void 0 ? void 0 : _option$onClick.call(option);
    };

    return /*#__PURE__*/React.createElement(OuiContextMenuItem, {
      key: "optionItem_".concat(index),
      className: itemClasses,
      color: color,
      icon: itemIcon(index),
      href: option.href,
      target: option.target,
      onClick: itemOnClick,
      onKeyDown: onItemKeyDown,
      layoutAlign: "center",
      buttonRef: function buttonRef(node) {
        return itemNodes[index] = node;
      },
      role: "option",
      id: "splitButtonItem_".concat(index),
      "aria-selected": isSelected ? 'true' : 'false'
    }, content);
  }); // return <div>SplitButton</div>;

  return /*#__PURE__*/React.createElement(OuiPopover, {
    ownFocus: false,
    hasArrow: false,
    anchorPosition: "downRight",
    button: button,
    panelRef: panelRef,
    className: popoverClasses,
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    panelPaddingSize: "none"
  }, /*#__PURE__*/React.createElement(OuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("p", {
    role: "alert"
  }, /*#__PURE__*/React.createElement(OuiI18n, {
    token: "ouiSplitButton.screenReaderAnnouncement",
    default: "You are in a selector of {optionsCount} items and must select a single option. Use the up and down keys to navigate or escape to close.",
    values: {
      optionsCount: options === null || options === void 0 ? void 0 : options.length
    }
  }))), /*#__PURE__*/React.createElement(OuiFocusTrap, {
    clickOutsideDisables: true
  }, /*#__PURE__*/React.createElement("div", {
    onKeyDown: onKeyDown
  }, /*#__PURE__*/React.createElement("div", {
    className: "ouiSplitButton__listbox",
    role: "listbox",
    "aria-activedescendant": "".concat(selectedIndex),
    tabIndex: 0
  }, items))));
};
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */
export { EuiSplitButton } from '../../eui_components/split_button/split_button';