/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.codehaus.xfire.gen.BaseServicesGenTask;
import org.codehaus.xfire.gen.documentation.DocumentationConfigGen;
import org.codehaus.xfire.service.Service;

public class WsDocGenTask
extends BaseServicesGenTask {
    private String outputDirectory;
    private String srcDirectory;
    private String filePath;
    private String[] files;
    private List<String> services = new ArrayList<String>();

    public void execute() throws BuildException {
        System.out.print("\n WSDocGenTask \n");
        System.out.print("OutputDirectory :" + this.getOutputDirectory() + "\n");
        System.out.print("srcDirectory :" + this.getSrcDirectory() + "\n");
        System.out.print("filePath :" + this.getFilePath() + "\n");
        System.out.print("configUrl :" + this.getConfigUrl() + "\n");
        if (!this.validateParams()) {
            return;
        }
        String[] srcFiles = null;
        DocumentationConfigGen gen = new DocumentationConfigGen();
        gen.setOutputFolder(this.outputDirectory);
        if (this.getConfigUrl() != null) {
            this.iterateServices();
            srcFiles = this.services.toArray(new String[this.services.size()]);
        } else {
            srcFiles = this.filePath != null ? new String[]{this.filePath} : this.files;
        }
        gen.setSrcFiles(srcFiles);
        gen.generate();
    }

    private boolean validateParams() {
        if (this.getSrcDirectory() == null) {
            System.out.print("SrcDirectory not specified. \n");
            return false;
        }
        return true;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    protected void processService(Service service) {
        String name = service.getServiceInfo().getServiceClass().getName();
        System.out.print(name + "\n");
        this.services.add(this.nameToPath(name));
    }

    private String nameToPath(String name) {
        String path = this.getSrcDirectory();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        name = name.replaceAll("\\.", "/");
        return path + name + ".java";
    }

    public String getSrcDirectory() {
        return this.srcDirectory;
    }

    public void setSrcDirectory(String srcDirectory) {
        this.srcDirectory = srcDirectory;
    }
}

