/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { Config, EditorType, CompletedToolCall, ToolCallRequestInfo } from '@google/gemini-cli-core';
import { type TrackedScheduledToolCall, type TrackedValidatingToolCall, type TrackedWaitingToolCall, type TrackedExecutingToolCall, type TrackedCompletedToolCall, type TrackedCancelledToolCall, type MarkToolsAsSubmittedFn, type CancelAllFn } from './useReactToolScheduler.js';
import { type TrackedToolCall } from './useToolExecutionScheduler.js';
export type { TrackedToolCall, TrackedScheduledToolCall, TrackedValidatingToolCall, TrackedWaitingToolCall, TrackedExecutingToolCall, TrackedCompletedToolCall, TrackedCancelledToolCall, MarkToolsAsSubmittedFn, CancelAllFn, };
export type ScheduleFn = (request: ToolCallRequestInfo | ToolCallRequestInfo[], signal: AbortSignal) => Promise<void | CompletedToolCall[]>;
export type UseToolSchedulerReturn = [
    TrackedToolCall[],
    ScheduleFn,
    MarkToolsAsSubmittedFn,
    React.Dispatch<React.SetStateAction<TrackedToolCall[]>>,
    CancelAllFn,
    number
];
/**
 * Hook that uses the Event-Driven scheduler for tool execution.
 */
export declare function useToolScheduler(onComplete: (tools: CompletedToolCall[]) => Promise<void>, config: Config, getPreferredEditor: () => EditorType | undefined): UseToolSchedulerReturn;
