/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemContentRootContributor;
import com.intellij.openapi.module.Module;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.GradleContentRootContributorKt;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/GradleContentRootContributor;", "Lcom/intellij/openapi/externalSystem/util/ExternalSystemContentRootContributor;", "<init>", "()V", "isApplicable", "", "systemId", "", "findContentRoots", "", "Lcom/intellij/openapi/externalSystem/util/ExternalSystemContentRootContributor$ExternalContentRoot;", "module", "Lcom/intellij/openapi/module/Module;", "sourceTypes", "Lcom/intellij/openapi/externalSystem/model/project/ExternalSystemSourceType;", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleContentRootContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleContentRootContributor.kt\norg/jetbrains/plugins/gradle/GradleContentRootContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1634#2,3:52\n*S KotlinDebug\n*F\n+ 1 GradleContentRootContributor.kt\norg/jetbrains/plugins/gradle/GradleContentRootContributor\n*L\n26#1:52,3\n*E\n"})
public final class GradleContentRootContributor
implements ExternalSystemContentRootContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull String systemId) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        return Intrinsics.areEqual((Object)systemId, (Object)GradleConstants.SYSTEM_ID.getId());
    }

    @NotNull
    public Collection<ExternalSystemContentRootContributor.ExternalContentRoot> findContentRoots(@NotNull Module module, @NotNull Collection<? extends ExternalSystemSourceType> sourceTypes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(sourceTypes, (String)"sourceTypes");
        List $this$findContentRoots_u24lambda_u242 = list = (List)new ArrayList();
        boolean bl = false;
        Companion.processContentRoots$intellij_gradle(module, (Function1<? super ContentRootData, Unit>)((Function1)arg_0 -> GradleContentRootContributor.findContentRoots$lambda$2$lambda$1(sourceTypes, $this$findContentRoots_u24lambda_u242, arg_0)));
        return CollectionsKt.toList((Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit findContentRoots$lambda$2$lambda$1(Collection $sourceTypes, List $this_apply, ContentRootData rootData) {
        Intrinsics.checkNotNullParameter((Object)rootData, (String)"rootData");
        for (ExternalSystemSourceType sourceType : $sourceTypes) {
            void $this$mapTo$iv;
            Collection collection = rootData.getPaths(sourceType);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPaths(...)");
            Iterable iterable = collection;
            Collection destination$iv = $this_apply;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                ContentRootData.SourceRoot sourceRoot = (ContentRootData.SourceRoot)item$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Path path = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                collection2.add(new ExternalSystemContentRootContributor.ExternalContentRoot(path, sourceType));
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/GradleContentRootContributor$Companion;", "", "<init>", "()V", "processContentRoots", "", "module", "Lcom/intellij/openapi/module/Module;", "processor", "Lkotlin/Function1;", "Lcom/intellij/openapi/externalSystem/model/project/ContentRootData;", "processContentRoots$intellij_gradle", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public final void processContentRoots$intellij_gradle(@NotNull Module module, @NotNull Function1<? super ContentRootData, Unit> processor) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            DataNode<ModuleData> dataNode = GradleUtil.findGradleModuleData(module);
            if (dataNode == null) {
                return;
            }
            DataNode<ModuleData> moduleData = dataNode;
            GradleContentRootContributorKt.access$processModule(moduleData, processor);
            for (DataNode eachSourceSetNode : ExternalSystemApiUtil.getChildren(moduleData, GradleSourceSetData.KEY)) {
                Intrinsics.checkNotNull((Object)eachSourceSetNode);
                GradleContentRootContributorKt.access$processModule(eachSourceSetNode, processor);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

