/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFragment;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class FragmentManipulator
extends AbstractElementManipulator<PsiFragment> {
    public PsiFragment handleContentChange(@NotNull PsiFragment expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText;
        if (expr == null) {
            FragmentManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            FragmentManipulator.$$$reportNull$$$0(1);
        }
        if ((oldText = expr.getText()).startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters((String)newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getElementFactory(expr.getProject()).createExpressionFromText(newText, null);
        return (PsiFragment)expr.replace(newExpr);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiFragment element) {
        if (element == null) {
            FragmentManipulator.$$$reportNull$$$0(2);
        }
        return FragmentManipulator.getValueRange(element);
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiFragment fragment) {
        if (fragment == null) {
            FragmentManipulator.$$$reportNull$$$0(3);
        }
        TextRange textRange = fragment.createLiteralTextEscaper().getRelevantTextRange();
        if (textRange == null) {
            FragmentManipulator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/FragmentManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/FragmentManipulator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueRange";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

