/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ClientData;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceServerUnavailable;

public class ConnectionInfo {
    private final Map<String, List<String>> myInfo;
    private final ClientData myClient;
    private final VcsException myException;

    ConnectionInfo(@NotNull Map<String, List<String>> info, @NotNull ClientData client) {
        if (info == null) {
            ConnectionInfo.$$$reportNull$$$0(0);
        }
        if (client == null) {
            ConnectionInfo.$$$reportNull$$$0(1);
        }
        this.myInfo = info;
        this.myClient = client;
        this.myException = null;
    }

    ConnectionInfo(VcsException exception) {
        this.myInfo = Collections.emptyMap();
        this.myClient = new ClientData(Collections.emptyMap());
        this.myException = exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionInfo)) {
            return false;
        }
        ConnectionInfo info1 = (ConnectionInfo)o;
        return this.myClient.equals(info1.myClient) && this.myInfo.equals(info1.myInfo) && Comparing.equal((Object)((Object)this.myException), (Object)((Object)info1.myException));
    }

    public int hashCode() {
        int result = this.myInfo.hashCode();
        result = 31 * result + this.myClient.hashCode();
        if (this.myException != null) {
            result = 31 * result + ((Object)((Object)this.myException)).hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.myException != null) {
            return this.myException.getMessage();
        }
        return MoreObjects.toStringHelper((Object)this).add("info", this.myInfo).add("client", (Object)this.myClient).toString();
    }

    private static void wrapAndThrow(VcsException vcsException) throws VcsException {
        if (vcsException instanceof PerforceAuthenticationException) {
            throw new PerforceAuthenticationException((PerforceAuthenticationException)((Object)vcsException));
        }
        if (vcsException instanceof PerforceServerUnavailable) {
            throw new PerforceServerUnavailable((PerforceServerUnavailable)((Object)vcsException));
        }
        throw new VcsException((Throwable)vcsException);
    }

    Map<String, List<String>> getInfo() throws VcsException {
        if (this.myException != null) {
            ConnectionInfo.wrapAndThrow(this.myException);
        }
        return Collections.unmodifiableMap(this.myInfo);
    }

    ClientData getClient() throws VcsException {
        if (this.myException != null) {
            ConnectionInfo.wrapAndThrow(this.myException);
        }
        return this.myClient;
    }

    boolean hasErrorsBesidesAuthentication() {
        return this.myException != null && !(this.myException instanceof PerforceAuthenticationException);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "client";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/perforce/application/ConnectionInfo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

