/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.clientConfiguration;

import com.intellij.mcpserver.clientConfiguration.ExistingConfig;
import com.intellij.mcpserver.clientConfiguration.MCPClientNames;
import com.intellij.mcpserver.clientConfiguration.McpClient;
import com.intellij.mcpserver.clientConfiguration.ServerConfig;
import com.intellij.mcpserver.clientConfiguration.VSCodeConfig;
import com.intellij.mcpserver.clientConfiguration.VSCodeSSEConfig;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/mcpserver/clientConfiguration/VSCodeClient;", "Lcom/intellij/mcpserver/clientConfiguration/McpClient;", "configPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "isConfigured", "", "()Ljava/lang/Boolean;", "getSSEConfig", "Lcom/intellij/mcpserver/clientConfiguration/ServerConfig;", "readMcpServers", "", "", "Lcom/intellij/mcpserver/clientConfiguration/ExistingConfig;", "buildUpdatedConfig", "Lkotlinx/serialization/json/JsonObject;", "existingConfig", "serverEntry", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nclients.kt\nKotlin\n*S Kotlin\n*F\n+ 1 clients.kt\ncom/intellij/mcpserver/clientConfiguration/VSCodeClient\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,243:1\n80#2:244\n29#3,3:245\n29#3,2:248\n29#3,2:250\n31#3:255\n31#3:256\n216#4,2:252\n324#5:254\n*S KotlinDebug\n*F\n+ 1 clients.kt\ncom/intellij/mcpserver/clientConfiguration/VSCodeClient\n*L\n229#1:244\n234#1:245,3\n236#1:248,2\n237#1:250,2\n237#1:255\n236#1:256\n238#1:252,2\n239#1:254\n*E\n"})
public final class VSCodeClient
extends McpClient {
    public VSCodeClient(@NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        super(MCPClientNames.VS_CODE_GLOBAL, configPath);
    }

    @Override
    @Nullable
    public Boolean isConfigured() {
        Boolean bl = this.isStdIOConfigured();
        if (bl == null) {
            return null;
        }
        boolean stdio = bl;
        Boolean bl2 = this.isSSEConfigured();
        if (bl2 == null) {
            return null;
        }
        boolean sse = bl2;
        return stdio || sse;
    }

    @Override
    @NotNull
    protected ServerConfig getSSEConfig() {
        return new VSCodeSSEConfig(this.getSseUrl(), "sse");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Map<String, ExistingConfig> readMcpServers() {
        Object object;
        Object object2 = this;
        try {
            void $this$decodeFromStream$iv;
            VSCodeClient $this$readMcpServers_u24lambda_u240 = object2;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists($this$readMcpServers_u24lambda_u240.getConfigPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            Json json = McpClient.Companion.getJson();
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream($this$readMcpServers_u24lambda_u240.getConfigPath(), Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            InputStream stream$iv = inputStream;
            boolean $i$f$decodeFromStream = false;
            $this$decodeFromStream$iv.getSerializersModule();
            Map map = ((VSCodeConfig)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)VSCodeConfig.Companion.serializer()), (InputStream)stream$iv)).getServers();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            object = Result.constructor-impl(map);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Map)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected JsonObject buildUpdatedConfig(@NotNull JsonObject existingConfig, @NotNull ServerConfig serverEntry) {
        void $this$encodeToJsonElement$iv;
        void $this$buildUpdatedConfig_u24lambda_u244_u24lambda_u243;
        JsonObjectBuilder builder$iv;
        JsonObjectBuilder builder$iv2;
        Intrinsics.checkNotNullParameter((Object)existingConfig, (String)"existingConfig");
        Intrinsics.checkNotNullParameter((Object)serverEntry, (String)"serverEntry");
        JsonElement jsonElement = (JsonElement)existingConfig.get((Object)"servers");
        if (jsonElement == null || (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) == null) {
            JsonObjectBuilder builder$iv3;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$buildUpdatedConfig_u24lambda_u241 = builder$iv3 = new JsonObjectBuilder();
            boolean bl = false;
            jsonElement = builder$iv3.build();
        }
        JsonElement existingServers = jsonElement;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$buildUpdatedConfig_u24lambda_u244 = builder$iv2 = new JsonObjectBuilder();
        boolean bl = false;
        boolean $i$f$buildJsonObject2 = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        String string = "servers";
        JsonObjectBuilder jsonObjectBuilder2 = $this$buildUpdatedConfig_u24lambda_u244;
        boolean bl2 = false;
        Map $this$forEach$iv = (Map)existingServers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl3 = false;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            $this$buildUpdatedConfig_u24lambda_u244_u24lambda_u243.put(key, value);
        }
        $this$forEach$iv = McpClient.Companion.getJson();
        ServerConfig value$iv = serverEntry;
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        $this$buildUpdatedConfig_u24lambda_u244_u24lambda_u243.put("jetbrains", $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)ServerConfig.Companion.serializer(), (Object)value$iv));
        Unit unit = Unit.INSTANCE;
        jsonObjectBuilder2.put(string, (JsonElement)builder$iv.build());
        return builder$iv2.build();
    }
}

