/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application.annotation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.jetbrains.idea.perforce.PerforceBundle;

public final class AnnotationInfo {
    private final String myContent;
    private final long[] myRevisions;
    private final boolean myUseChangelistNumbers;
    private static final Logger LOG = Logger.getInstance(AnnotationInfo.class);

    public AnnotationInfo(String output, boolean useChangelistNumbers) throws IOException, VcsException {
        this.myUseChangelistNumbers = useChangelistNumbers;
        LineNumberReader reader = new LineNumberReader(new StringReader(output));
        StringBuilder content = new StringBuilder();
        LongArrayList revisions = new LongArrayList();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int endOfRevisionIndex = line.indexOf(":");
                if (endOfRevisionIndex <= 0) continue;
                String revision = line.substring(0, endOfRevisionIndex);
                String contentLine = line.substring(endOfRevisionIndex + 2);
                content.append(contentLine);
                content.append("\n");
                revisions.add(Long.parseLong(revision));
            }
        }
        catch (NumberFormatException e) {
            LOG.info("Can not parse annotation output: \n'" + output + "'", (Throwable)e);
            throw new VcsException(PerforceBundle.message("error.can.not.parse.annotation.output", new Object[0]), (Throwable)e);
        }
        this.myContent = content.toString();
        this.myRevisions = revisions.toLongArray();
    }

    public String getContent() {
        return this.myContent;
    }

    public long getRevision(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.myRevisions.length) {
            return -1L;
        }
        return this.myRevisions[lineNumber];
    }

    public boolean isUseChangelistNumbers() {
        return this.myUseChangelistNumbers;
    }

    public int getLineCount() {
        return this.myRevisions.length;
    }
}

