/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;

public class GroovyClassNameInsertHandler
implements InsertHandler<JavaPsiClassReferenceElement> {
    @Nullable
    private static GrNewExpression findNewExpression(@Nullable PsiElement position) {
        if (position == null) {
            return null;
        }
        PsiElement reference = position.getParent();
        if (!(reference instanceof GrCodeReferenceElement)) {
            return null;
        }
        PsiElement parent = reference.getParent();
        while (parent instanceof GrCodeReferenceElement) {
            parent = parent.getParent();
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            parent = parent.getParent();
        }
        return parent instanceof GrNewExpression ? (GrNewExpression)parent : null;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull JavaPsiClassReferenceElement item) {
        Editor editor;
        int endOffset;
        PsiFile file;
        if (context == null) {
            GroovyClassNameInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            GroovyClassNameInsertHandler.$$$reportNull$$$0(1);
        }
        if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)(file = context.getFile()), (int)((endOffset = (editor = context.getEditor()).getCaretModel().getOffset()) - 1), GrImportStatement.class, (boolean)false) != null || !(file instanceof GroovyFileBase)) {
            AllClassesGetter.INSERT_FQN.handleInsert(context, (LookupElement)item);
            return;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
        PsiElement position = file.findElementAt(endOffset - 1);
        boolean parens = GroovyClassNameInsertHandler.shouldInsertParentheses(position);
        PsiClass psiClass = item.getObject();
        if (GroovyClassNameInsertHandler.isInVariable(position) || GroovyCompletionUtil.isInPossibleClosureParameter(position)) {
            Project project = context.getProject();
            String qname = psiClass.getQualifiedName();
            String shortName = psiClass.getName();
            if (qname == null) {
                return;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedClass(shortName, position);
            if (aClass == null) {
                ((GroovyFileBase)file).addImportForClass(psiClass);
                return;
            }
            if (aClass == CompletionUtil.getOriginalOrSelf((PsiElement)psiClass)) {
                return;
            }
        }
        AllClassesGetter.TRY_SHORTENING.handleInsert(context, (LookupElement)item);
        if (parens && context.getCompletionChar() != '[') {
            int identifierEnd = context.getTailOffset();
            GroovyPsiElement place = (GroovyPsiElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), GroovyPsiElement.class, (boolean)false);
            JavaCompletionUtil.insertParentheses((InsertionContext)context, (LookupElement)item, (boolean)false, (place != null && GroovyCompletionUtil.hasConstructorParameters(psiClass, place) ? 1 : 0) != 0);
            if (context.getCompletionChar() == '<' || psiClass.hasTypeParameters() && context.getCompletionChar() != '(') {
                context.setAddCompletionChar(false);
                JavaCompletionUtil.promptTypeArgs((InsertionContext)context, (int)identifierEnd);
            }
        }
    }

    private static boolean shouldInsertParentheses(PsiElement position) {
        GrNewExpression newExpression = GroovyClassNameInsertHandler.findNewExpression(position);
        return newExpression != null && ContainerUtil.findInstance(GroovyExpectedTypesProvider.getDefaultExpectedTypes(newExpression), PsiArrayType.class) == null;
    }

    private static boolean isInVariable(@Nullable PsiElement position) {
        if (position == null) {
            return false;
        }
        PsiElement parent = position.getParent();
        if (parent instanceof GrVariable) {
            return ((GrVariable)parent).getTypeElementGroovy() == null && position == ((GrVariable)parent).getNameIdentifierGroovy();
        }
        if (parent instanceof GrCatchClause) {
            return ((GrCatchClause)parent).getParameter() == null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovyClassNameInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

