/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrPrivateDeclarationOverrideChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrPrivateDeclarationOverrideChecker
implements IrDeclarationChecker<IrDeclaration> {
    @NotNull
    public static final IrPrivateDeclarationOverrideChecker INSTANCE = new IrPrivateDeclarationOverrideChecker();

    private IrPrivateDeclarationOverrideChecker() {
    }

    @Override
    public void check(@NotNull IrDeclaration declaration, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (declaration instanceof IrOverridableDeclaration) {
            for (IrSymbol overriddenSymbol : ((IrOverridableDeclaration)declaration).getOverriddenSymbols()) {
                IrDeclarationWithVisibility overriddenDeclaration;
                IrSymbolOwner irSymbolOwner = overriddenSymbol.getOwner();
                IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
                if (irDeclarationWithVisibility == null || !Intrinsics.areEqual((overriddenDeclaration = irDeclarationWithVisibility).getVisibility(), DescriptorVisibilities.PRIVATE)) continue;
                context2.error(declaration, "Overrides private declaration " + RenderIrElementKt.render$default(overriddenDeclaration, null, 1, null));
            }
        }
    }
}

