/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J]\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2$\u0010\r\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\b0\u0012\"\u0002H\bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "lowerConst", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "C", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "irClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "carrierFactory", "Lkotlin/Function4;", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "args", "", "(Lorg/jetbrains/kotlin/ir/expressions/IrConst;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lkotlin/jvm/functions/Function4;[Ljava/lang/Object;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "createLong", "v", "", "visitConst", "backend.js"})
@SourceDebugExtension(value={"SMAP\nConstLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,109:1\n350#2,12:110\n*S KotlinDebug\n*F\n+ 1 ConstLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer\n*L\n35#1:110,12\n*E\n"})
public final class ConstTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;

    public ConstTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    private final <C> IrExpression lowerConst(IrConst expression2, IrClassSymbol irClass, Function4<? super Integer, ? super Integer, ? super IrType, ? super C, ? extends IrExpression> carrierFactory, C ... args) {
        IrConstructorCallImpl irConstructorCallImpl;
        Sequence<IrConstructorSymbol> $this$single$iv = IrUtilsKt.getConstructors(irClass);
        boolean $i$f$single = false;
        IrConstructorSymbol single$iv = null;
        boolean found$iv = false;
        Iterator<IrConstructorSymbol> iterator2 = $this$single$iv.iterator();
        while (iterator2.hasNext()) {
            IrConstructorSymbol element$iv;
            IrConstructorSymbol it = element$iv = iterator2.next();
            boolean bl = false;
            if (!((IrConstructor)it.getOwner()).isPrimary()) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructorSymbol constructor = single$iv;
        IrType argType = ((IrConstructor)constructor.getOwner()).getParameters().get(0).getType();
        IrConstructorCallImpl $this$lowerConst_u24lambda_u241 = irConstructorCallImpl = BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), (IrType)IrTypesKt.getDefaultType(irClass), constructor, null, 16, null);
        boolean bl = false;
        int n2 = args.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            $this$lowerConst_u24lambda_u241.getArguments().set(i2, carrierFactory.invoke($this$lowerConst_u24lambda_u241.getStartOffset(), $this$lowerConst_u24lambda_u241.getEndOffset(), argType, args[i2]));
        }
        return irConstructorCallImpl;
    }

    private final IrExpression createLong(IrConst expression2, long v2) {
        Integer[] integerArray = new Integer[]{(int)v2, (int)(v2 >> 32)};
        return this.lowerConst(expression2, this.context.getIntrinsics().getLongClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl>((Object)IrConstImpl.Companion){

            public final IrConstImpl invoke(int p0, int p1, IrType p2, int p3) {
                Intrinsics.checkNotNullParameter(p2, "p2");
                return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
            }
        }, integerArray);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        JsIntrinsics $this$visitConst_u24lambda_u243 = this.context.getIntrinsics();
        boolean bl = false;
        if (IrTypeUtilsKt.isUnsigned(expression2.getType()) && !Intrinsics.areEqual(expression2.getKind(), IrConstKind.Null.INSTANCE)) {
            IrExpression irExpression2;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(expression2.getType());
            if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u243.getUByteClassSymbol())) {
                IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u243.getUByteClassSymbol();
                Function4 function4 = new Function4<Integer, Integer, IrType, Byte, IrConstImpl>((Object)IrConstImpl.Companion){

                    public final IrConstImpl invoke(int p0, int p1, IrType p2, byte p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).byte(p0, p1, p2, p3);
                    }
                };
                Byte[] byteArray = new Byte[1];
                Intrinsics.checkNotNull(expression2.getValue(), "null cannot be cast to non-null type kotlin.Byte");
                irExpression2 = this.lowerConst(expression2, irClassSymbol, function4, byteArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u243.getUShortClassSymbol())) {
                IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u243.getUShortClassSymbol();
                Function4 function4 = new Function4<Integer, Integer, IrType, Short, IrConstImpl>((Object)IrConstImpl.Companion){

                    public final IrConstImpl invoke(int p0, int p1, IrType p2, short p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).short(p0, p1, p2, p3);
                    }
                };
                Short[] shortArray = new Short[1];
                Intrinsics.checkNotNull(expression2.getValue(), "null cannot be cast to non-null type kotlin.Short");
                irExpression2 = this.lowerConst(expression2, irClassSymbol, function4, shortArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u243.getUIntClassSymbol())) {
                IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u243.getUIntClassSymbol();
                Function4 function4 = new Function4<Integer, Integer, IrType, Integer, IrConstImpl>((Object)IrConstImpl.Companion){

                    public final IrConstImpl invoke(int p0, int p1, IrType p2, int p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
                    }
                };
                Integer[] integerArray = new Integer[1];
                Intrinsics.checkNotNull(expression2.getValue(), "null cannot be cast to non-null type kotlin.Int");
                irExpression2 = this.lowerConst(expression2, irClassSymbol, function4, integerArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u243.getULongClassSymbol())) {
                IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u243.getULongClassSymbol();
                Function4<Integer, Integer, IrType, Long, IrExpression> function4 = (arg_0, arg_1, arg_2, arg_3) -> ConstTransformer.visitConst$lambda$3$lambda$2(this, expression2, arg_0, arg_1, arg_2, arg_3);
                Long[] longArray = new Long[1];
                Intrinsics.checkNotNull(expression2.getValue(), "null cannot be cast to non-null type kotlin.Long");
                irExpression2 = this.lowerConst(expression2, irClassSymbol, function4, longArray);
            } else {
                CompilationExceptionKt.compilationException("Unknown unsigned type", expression2);
                throw new KotlinNothingValueException();
            }
            return irExpression2;
        }
        if (expression2.getKind() instanceof IrConstKind.Char) {
            IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u243.getCharClassSymbol();
            Function4 function4 = new Function4<Integer, Integer, IrType, Integer, IrConstImpl>((Object)IrConstImpl.Companion){

                public final IrConstImpl invoke(int p0, int p1, IrType p2, int p3) {
                    Intrinsics.checkNotNullParameter(p2, "p2");
                    return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
                }
            };
            Integer[] integerArray = new Integer[1];
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Char");
            integerArray[0] = ((Character)object).charValue();
            irExpression = this.lowerConst(expression2, irClassSymbol, function4, integerArray);
        } else if (expression2.getKind() instanceof IrConstKind.Long) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Long");
            irExpression = this.createLong(expression2, (Long)object);
        } else {
            irExpression = super.visitConst(expression2);
        }
        return irExpression;
    }

    private static final IrExpression visitConst$lambda$3$lambda$2(ConstTransformer this$0, IrConst $expression, int n2, int n3, IrType irType, long v2) {
        Intrinsics.checkNotNullParameter(irType, "<unused var>");
        return this$0.createLong($expression, v2);
    }
}

