/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.HelpAction;
import org.openstreetmap.josm.tools.I18n;

public class HelpMembershipAction
extends HelpAction {
    private final JTable membershipTable;
    private final IntFunction<IRelation<?>> memberValueSupplier;

    public HelpMembershipAction(JTable membershipTable, IntFunction<IRelation<?>> memberValueSupplier) {
        this.membershipTable = Objects.requireNonNull(membershipTable);
        this.memberValueSupplier = Objects.requireNonNull(memberValueSupplier);
        this.putValue("Name", I18n.tr("Go to OSM wiki for relation help", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.membershipTable.getSelectedRowCount() == 1) {
            int row = this.membershipTable.getSelectedRow();
            IRelation<?> relation = this.memberValueSupplier.apply(row);
            MainApplication.worker.execute(() -> HelpMembershipAction.displayRelationHelp(relation));
        } else {
            super.actionPerformed(e);
        }
    }
}

