/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aesh.command.Command;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainerBuilder;
import org.aesh.command.parser.CommandLineParserException;

public class AeshInternalCommandRegistry {
    private final Map<String, CommandContainer> registry = new HashMap<String, CommandContainer>();

    public void addCommand(Command command) throws CommandLineParserException {
        this.putIntoRegistry(new AeshCommandContainerBuilder().create(command));
    }

    private void putIntoRegistry(CommandContainer commandContainer) {
        if (!commandContainer.haveBuildError() && !this.registry.containsKey(commandContainer.getParser().getProcessedCommand().name())) {
            this.registry.put(commandContainer.getParser().getProcessedCommand().name(), commandContainer);
        }
    }

    public CommandContainer getCommand(String name) {
        return this.registry.get(name);
    }

    public Set<String> getAllCommandNames() {
        return this.registry.keySet();
    }
}

