/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import twitter4j.AccessToken;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.JSONImplFactory;
import twitter4j.NullAuthorization;
import twitter4j.OAuth2Authorization;
import twitter4j.OAuth2Token;
import twitter4j.OAuthAuthorization;
import twitter4j.ObjectFactory;
import twitter4j.PropertyConfiguration;
import twitter4j.RateLimitStatusEvent;

class Configuration<T2 extends Configuration> {
    List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners = new ArrayList<Consumer<RateLimitStatusEvent>>(0);
    List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners = new ArrayList<Consumer<RateLimitStatusEvent>>(0);
    String user = null;
    String password = null;
    String httpProxyHost = null;
    String httpProxyUser = null;
    String httpProxyPassword = null;
    boolean httpProxySocks = false;
    int httpProxyPort = -1;
    int httpConnectionTimeout = 20000;
    int httpReadTimeout = 120000;
    boolean prettyDebug = false;
    boolean gzipEnabled = true;
    private int httpStreamingReadTimeout = 40000;
    int httpRetryCount = 0;
    int httpRetryIntervalSeconds = 5;
    String oAuthConsumerKey = null;
    String oAuthConsumerSecret = null;
    String oAuthAccessToken = null;
    String oAuthAccessTokenSecret = null;
    String oAuthRealm = null;
    String oAuth2TokenType;
    String oAuth2AccessToken;
    String oAuth2Scope;
    String oAuthRequestTokenURL = "https://api.twitter.com/oauth/request_token";
    String oAuthAuthorizationURL = "https://api.twitter.com/oauth/authorize";
    String oAuthAccessTokenURL = "https://api.twitter.com/oauth/access_token";
    String oAuthAuthenticationURL = "https://api.twitter.com/oauth/authenticate";
    String oAuthInvalidateTokenURL = "https://api.twitter.com/1.1/oauth/invalidate_token";
    String oAuth2TokenURL = "https://api.twitter.com/oauth2/token";
    String oAuth2InvalidateTokenURL = "https://api.twitter.com/oauth2/invalidate_token";
    String restBaseURL = "https://api.twitter.com/1.1/";
    String streamBaseURL = "https://stream.twitter.com/1.1/";
    String uploadBaseURL = "https://upload.twitter.com/1.1/";
    long contributingTo = -1L;
    boolean includeEntitiesEnabled = true;
    boolean trimUserEnabled = false;
    boolean includeExtAltTextEnabled = true;
    boolean tweetModeExtended = true;
    boolean jsonStoreEnabled = false;
    boolean mbeanEnabled = false;
    boolean stallWarningsEnabled = true;
    boolean applicationOnlyAuthEnabled = false;
    String streamThreadName = "";
    Authorization auth;
    HttpClient http;
    ObjectFactory factory;
    private static final String WWW_DETAILS = "See https://twitter4j.org/en/configuration.html for details. See and register at https://apps.twitter.com/";

    Configuration() {
        PropertyConfiguration.loadDefaultProperties(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.httpProxySocks == that.httpProxySocks && this.httpProxyPort == that.httpProxyPort && this.httpConnectionTimeout == that.httpConnectionTimeout && this.httpReadTimeout == that.httpReadTimeout && this.prettyDebug == that.prettyDebug && this.gzipEnabled == that.gzipEnabled && this.httpStreamingReadTimeout == that.httpStreamingReadTimeout && this.httpRetryCount == that.httpRetryCount && this.httpRetryIntervalSeconds == that.httpRetryIntervalSeconds && this.contributingTo == that.contributingTo && this.includeEntitiesEnabled == that.includeEntitiesEnabled && this.trimUserEnabled == that.trimUserEnabled && this.includeExtAltTextEnabled == that.includeExtAltTextEnabled && this.tweetModeExtended == that.tweetModeExtended && this.jsonStoreEnabled == that.jsonStoreEnabled && this.mbeanEnabled == that.mbeanEnabled && this.stallWarningsEnabled == that.stallWarningsEnabled && this.applicationOnlyAuthEnabled == that.applicationOnlyAuthEnabled && Objects.equals(this.rateLimitStatusListeners, that.rateLimitStatusListeners) && Objects.equals(this.rateLimitReachedListeners, that.rateLimitReachedListeners) && Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password) && Objects.equals(this.httpProxyHost, that.httpProxyHost) && Objects.equals(this.httpProxyUser, that.httpProxyUser) && Objects.equals(this.httpProxyPassword, that.httpProxyPassword) && Objects.equals(this.oAuthConsumerKey, that.oAuthConsumerKey) && Objects.equals(this.oAuthConsumerSecret, that.oAuthConsumerSecret) && Objects.equals(this.oAuthAccessToken, that.oAuthAccessToken) && Objects.equals(this.oAuthAccessTokenSecret, that.oAuthAccessTokenSecret) && Objects.equals(this.oAuthRealm, that.oAuthRealm) && Objects.equals(this.oAuth2TokenType, that.oAuth2TokenType) && Objects.equals(this.oAuth2AccessToken, that.oAuth2AccessToken) && Objects.equals(this.oAuth2Scope, that.oAuth2Scope) && Objects.equals(this.oAuthRequestTokenURL, that.oAuthRequestTokenURL) && Objects.equals(this.oAuthAuthorizationURL, that.oAuthAuthorizationURL) && Objects.equals(this.oAuthAccessTokenURL, that.oAuthAccessTokenURL) && Objects.equals(this.oAuthAuthenticationURL, that.oAuthAuthenticationURL) && Objects.equals(this.oAuthInvalidateTokenURL, that.oAuthInvalidateTokenURL) && Objects.equals(this.oAuth2TokenURL, that.oAuth2TokenURL) && Objects.equals(this.oAuth2InvalidateTokenURL, that.oAuth2InvalidateTokenURL) && Objects.equals(this.restBaseURL, that.restBaseURL) && Objects.equals(this.streamBaseURL, that.streamBaseURL) && Objects.equals(this.uploadBaseURL, that.uploadBaseURL) && Objects.equals(this.streamThreadName, that.streamThreadName) && Objects.equals(this.auth, that.auth) && Objects.equals(this.http, that.http) && Objects.equals(this.factory, that.factory);
    }

    public int hashCode() {
        return Objects.hash(this.rateLimitStatusListeners, this.rateLimitReachedListeners, this.user, this.password, this.httpProxyHost, this.httpProxyUser, this.httpProxyPassword, this.httpProxySocks, this.httpProxyPort, this.httpConnectionTimeout, this.httpReadTimeout, this.prettyDebug, this.gzipEnabled, this.httpStreamingReadTimeout, this.httpRetryCount, this.httpRetryIntervalSeconds, this.oAuthConsumerKey, this.oAuthConsumerSecret, this.oAuthAccessToken, this.oAuthAccessTokenSecret, this.oAuthRealm, this.oAuth2TokenType, this.oAuth2AccessToken, this.oAuth2Scope, this.oAuthRequestTokenURL, this.oAuthAuthorizationURL, this.oAuthAccessTokenURL, this.oAuthAuthenticationURL, this.oAuthInvalidateTokenURL, this.oAuth2TokenURL, this.oAuth2InvalidateTokenURL, this.restBaseURL, this.streamBaseURL, this.uploadBaseURL, this.contributingTo, this.includeEntitiesEnabled, this.trimUserEnabled, this.includeExtAltTextEnabled, this.tweetModeExtended, this.jsonStoreEnabled, this.mbeanEnabled, this.stallWarningsEnabled, this.applicationOnlyAuthEnabled, this.streamThreadName, this.auth, this.http, this.factory);
    }

    public String toString() {
        return "Configuration{user='" + this.user + '\'' + ", password='" + this.password + '\'' + ", httpProxyHost='" + this.httpProxyHost + '\'' + ", httpProxyUser='" + this.httpProxyUser + '\'' + ", httpProxyPassword='" + this.httpProxyPassword + '\'' + ", httpProxySocks=" + this.httpProxySocks + ", httpProxyPort=" + this.httpProxyPort + ", httpConnectionTimeout=" + this.httpConnectionTimeout + ", httpReadTimeout=" + this.httpReadTimeout + ", prettyDebug=" + this.prettyDebug + ", gzipEnabled=" + this.gzipEnabled + ", httpStreamingReadTimeout=" + this.httpStreamingReadTimeout + ", httpRetryCount=" + this.httpRetryCount + ", httpRetryIntervalSeconds=" + this.httpRetryIntervalSeconds + ", oAuthConsumerKey='" + this.oAuthConsumerKey + '\'' + ", oAuthConsumerSecret='" + this.mask(this.oAuthConsumerSecret) + '\'' + ", oAuth2AccessToken='" + this.mask(this.oAuth2AccessToken) + '\'' + ", oAuthAccessTokenSecret='" + this.mask(this.oAuthAccessTokenSecret) + '\'' + ", oAuth2TokenType='" + this.oAuth2TokenType + '\'' + ", oAuth2AccessToken='" + this.mask(this.oAuth2AccessToken) + '\'' + ", oAuth2Scope='" + this.oAuth2Scope + '\'' + ", oAuthRequestTokenURL='" + this.oAuthRequestTokenURL + '\'' + ", oAuthAuthorizationURL='" + this.oAuthAuthorizationURL + '\'' + ", oAuthAccessTokenURL='" + this.oAuthAccessTokenURL + '\'' + ", oAuthAuthenticationURL='" + this.oAuthAuthenticationURL + '\'' + ", oAuthInvalidateTokenURL='" + this.oAuthInvalidateTokenURL + '\'' + ", oAuth2TokenURL='" + this.oAuth2TokenURL + '\'' + ", oAuth2InvalidateTokenURL='" + this.oAuth2InvalidateTokenURL + '\'' + ", restBaseURL='" + this.restBaseURL + '\'' + ", streamBaseURL='" + this.streamBaseURL + '\'' + ", uploadBaseURL='" + this.uploadBaseURL + '\'' + ", contributingTo=" + this.contributingTo + ", includeEntitiesEnabled=" + this.includeEntitiesEnabled + ", trimUserEnabled=" + this.trimUserEnabled + ", includeExtAltTextEnabled=" + this.includeExtAltTextEnabled + ", tweetModeExtended=" + this.tweetModeExtended + ", jsonStoreEnabled=" + this.jsonStoreEnabled + ", mbeanEnabled=" + this.mbeanEnabled + ", stallWarningsEnabled=" + this.stallWarningsEnabled + ", applicationOnlyAuthEnabled=" + this.applicationOnlyAuthEnabled + ", streamThreadName='" + this.streamThreadName + '\'' + '}';
    }

    String mask(@Nullable String strToMask) {
        if (strToMask == null) {
            return "(null)";
        }
        return strToMask.replaceAll(".", "*");
    }

    public T2 prettyDebugEnabled(boolean prettyDebugEnabled) {
        this.prettyDebug = prettyDebugEnabled;
        return (T2)this;
    }

    public T2 gzipEnabled(boolean gzipEnabled) {
        this.gzipEnabled = gzipEnabled;
        return (T2)this;
    }

    public T2 applicationOnlyAuthEnabled(boolean applicationOnlyAuthEnabled) {
        this.applicationOnlyAuthEnabled = applicationOnlyAuthEnabled;
        return (T2)this;
    }

    public T2 load(Properties props) {
        PropertyConfiguration.load(this, props);
        return (T2)this;
    }

    public T2 httpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
        return (T2)this;
    }

    public T2 httpProxyUser(String httpProxyUser) {
        this.httpProxyUser = httpProxyUser;
        return (T2)this;
    }

    public T2 httpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
        return (T2)this;
    }

    public T2 httpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
        return (T2)this;
    }

    public T2 httpProxySocks(boolean httpProxySocks) {
        this.httpProxySocks = httpProxySocks;
        return (T2)this;
    }

    public T2 httpConnectionTimeout(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
        return (T2)this;
    }

    public T2 httpReadTimeout(int httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
        return (T2)this;
    }

    public T2 httpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.httpStreamingReadTimeout = httpStreamingReadTimeout;
        return (T2)this;
    }

    public T2 httpRetryCount(int httpRetryCount) {
        this.httpRetryCount = httpRetryCount;
        return (T2)this;
    }

    public T2 httpRetryIntervalSeconds(int httpRetryIntervalSeconds) {
        this.httpRetryIntervalSeconds = httpRetryIntervalSeconds;
        return (T2)this;
    }

    public T2 oAuthConsumer(String oAuthConsumerKey, String oAuthConsumerSecret) {
        this.oAuthConsumerKey = oAuthConsumerKey;
        this.oAuthConsumerSecret = oAuthConsumerSecret;
        return (T2)this;
    }

    public T2 oAuthAccessToken(String oAuthAccessToken, String oAuthAccessTokenSecret) {
        this.oAuthAccessToken = oAuthAccessToken;
        this.oAuthAccessTokenSecret = oAuthAccessTokenSecret;
        return (T2)this;
    }

    public T2 oAuthAccessToken(AccessToken accessToken) {
        this.oAuthAccessToken = accessToken.getToken();
        this.oAuthAccessTokenSecret = accessToken.getTokenSecret();
        return (T2)this;
    }

    public T2 oAuth2Token(String oAuth2TokenType, String oAuth2AccessToken) {
        this.oAuth2TokenType = oAuth2TokenType;
        this.oAuth2AccessToken = oAuth2AccessToken;
        return (T2)this;
    }

    public T2 oAuth2Token(OAuth2Token oAuth2Token) {
        this.oAuth2TokenType = oAuth2Token.getTokenType();
        this.oAuth2AccessToken = oAuth2Token.getAccessToken();
        return (T2)this;
    }

    public T2 oAuth2Scope(String oAuth2Scope) {
        this.oAuth2Scope = oAuth2Scope;
        return (T2)this;
    }

    public T2 contributingTo(long contributingTo) {
        this.contributingTo = contributingTo;
        return (T2)this;
    }

    public T2 trimUserEnabled(boolean enabled) {
        this.trimUserEnabled = enabled;
        return (T2)this;
    }

    public T2 includeExtAltTextEnabled(boolean enabled) {
        this.includeExtAltTextEnabled = enabled;
        return (T2)this;
    }

    public T2 tweetModeExtended(boolean enabled) {
        this.tweetModeExtended = enabled;
        return (T2)this;
    }

    public T2 includeEntitiesEnabled(boolean enabled) {
        this.includeEntitiesEnabled = enabled;
        return (T2)this;
    }

    public T2 jsonStoreEnabled(boolean enabled) {
        this.jsonStoreEnabled = enabled;
        return (T2)this;
    }

    public T2 mBeanEnabled(boolean enabled) {
        this.mbeanEnabled = enabled;
        return (T2)this;
    }

    public T2 onRateLimitStatus(Consumer<RateLimitStatusEvent> action) {
        this.rateLimitStatusListeners.add(action);
        return (T2)this;
    }

    public T2 onRateLimitReached(Consumer<RateLimitStatusEvent> action) {
        this.rateLimitReachedListeners.add(action);
        return (T2)this;
    }

    T2 buildConfiguration() {
        this.factory = new JSONImplFactory(this.jsonStoreEnabled);
        this.http = new HttpClient(this.httpProxyHost, this.httpProxyPort, this.httpProxyUser, this.httpProxyPassword, this.httpProxySocks, this.httpRetryCount, this.httpRetryIntervalSeconds, this.httpConnectionTimeout, this.httpReadTimeout, this.prettyDebug, this.gzipEnabled);
        String consumerKey = this.oAuthConsumerKey;
        String consumerSecret = this.oAuthConsumerSecret;
        if (consumerKey != null && consumerSecret != null) {
            this.auth = this.applicationOnlyAuthEnabled ? new OAuth2Authorization(this) : new OAuthAuthorization(this);
        }
        if (null == this.auth) {
            this.auth = NullAuthorization.getInstance();
        }
        return (T2)this;
    }

    void ensureAuthorizationEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Authentication credentials are missing. See https://twitter4j.org/en/configuration.html for details. See and register at https://apps.twitter.com/");
        }
    }
}

