/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class SingletonBeanFactory<T>
implements BeanFactory<T> {
    static final Map<String, Object> INSTANCES = new ConcurrentHashMap<String, Object>();
    private String className;

    public SingletonBeanFactory(String className) {
        this.className = className;
    }

    public SingletonBeanFactory() {
    }

    public String toString() {
        return "SingletonBeanFactory[" + this.className + "]";
    }

    @Override
    public BeanFactory.BeanInstance<T> createInstance() {
        final Object instance = INSTANCES.get(this.className);
        if (instance == null) {
            throw new RuntimeException("Singleton for " + this.className + " not found.");
        }
        return new BeanFactory.BeanInstance<T>(){

            @Override
            public T getInstance() {
                return instance;
            }

            @Override
            public void close() {
            }
        };
    }

    public String getClassName() {
        return this.className;
    }

    public SingletonBeanFactory<T> setClassName(String className) {
        this.className = className;
        return this;
    }

    public static void setInstance(String className, Object instance) {
        INSTANCES.put(className, instance);
    }
}

