/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.internal.AliasConstantsHelper;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.LegacyFetchBuilder;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.internal.complete.CompleteResultBuilderCollectionStandard;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ResultSetMappingProcessor
implements SQLQueryParser.ParserContext {
    private final ResultSetMapping resultSetMapping;
    private final Map<String, NativeQuery.ResultNode> alias2Return = new HashMap<String, NativeQuery.ResultNode>();
    private final Map<String, String> alias2OwnerAlias = new HashMap<String, String>();
    private final Map<String, EntityPersister> alias2Persister = new HashMap<String, EntityPersister>();
    private final Map<String, String> alias2Suffix = new HashMap<String, String>();
    private final Map<String, CollectionPersister> alias2CollectionPersister = new HashMap<String, CollectionPersister>();
    private final Map<String, String> alias2CollectionSuffix = new HashMap<String, String>();
    private final Map<String, Map<String, String[]>> entityPropertyResultMaps = new HashMap<String, Map<String, String[]>>();
    private final Map<String, Map<String, String[]>> collectionPropertyResultMaps = new HashMap<String, Map<String, String[]>>();
    private final SessionFactoryImplementor factory;
    private int entitySuffixSeed;
    private int collectionSuffixSeed;

    public ResultSetMappingProcessor(ResultSetMapping resultSetMapping, SessionFactoryImplementor factory) {
        this.resultSetMapping = resultSetMapping;
        this.factory = factory;
    }

    public SQLQueryParser.ParserContext process() {
        this.resultSetMapping.visitResultBuilders((i, resultBuilder) -> {
            if (resultBuilder instanceof NativeQuery.RootReturn) {
                NativeQuery.RootReturn rootReturn = (NativeQuery.RootReturn)((Object)resultBuilder);
                this.alias2Return.put(rootReturn.getTableAlias(), rootReturn);
                resultBuilder.visitFetchBuilders(this::processFetchBuilder);
            } else if (resultBuilder instanceof NativeQuery.CollectionReturn) {
                NativeQuery.CollectionReturn collectionReturn = (NativeQuery.CollectionReturn)((Object)resultBuilder);
                this.alias2Return.put(collectionReturn.getTableAlias(), collectionReturn);
                this.addCollection(collectionReturn.getNavigablePath().getFullPath(), collectionReturn.getTableAlias(), Collections.emptyMap());
            }
        });
        this.resultSetMapping.visitLegacyFetchBuilders(fetchBuilder -> {
            this.alias2Return.put(fetchBuilder.getTableAlias(), (NativeQuery.ReturnableResultNode)((Object)fetchBuilder));
            this.alias2OwnerAlias.put(fetchBuilder.getTableAlias(), fetchBuilder.getOwnerAlias());
        });
        for (NativeQuery.ResultNode queryReturn : this.alias2Return.values()) {
            this.processReturn(queryReturn);
        }
        return this;
    }

    private void processFetchBuilder(Fetchable attributeName, FetchBuilder fetchBuilder) {
        if (fetchBuilder instanceof LegacyFetchBuilder) {
            LegacyFetchBuilder legacyFetchBuilder = (LegacyFetchBuilder)fetchBuilder;
            this.resultSetMapping.addLegacyFetchBuilder(legacyFetchBuilder);
        } else if (fetchBuilder instanceof NativeQuery.FetchReturn) {
            NativeQuery.FetchReturn fetchReturn = (NativeQuery.FetchReturn)((Object)fetchBuilder);
            this.alias2Return.put(fetchReturn.getTableAlias(), fetchReturn);
            this.alias2OwnerAlias.put(fetchReturn.getTableAlias(), fetchReturn.getOwnerAlias());
        }
        fetchBuilder.visitFetchBuilders(this::processFetchBuilder);
    }

    public ResultSetMapping generateResultMapping(boolean queryHadAliases) {
        if (queryHadAliases) {
            ResultSetMapping mapping = ResultSetMapping.resolveResultSetMapping(null, false, this.factory);
            HashSet visited = new HashSet();
            this.resultSetMapping.visitResultBuilders((i, builder) -> this.visitResultSetBuilder(mapping, (ResultBuilder)builder, visited));
            this.resultSetMapping.visitLegacyFetchBuilders(builder -> this.applyFetchBuilder(mapping, (LegacyFetchBuilder)builder, visited));
            return mapping;
        }
        return this.resultSetMapping;
    }

    private void visitResultSetBuilder(ResultSetMapping resultSetMapping, ResultBuilder resultBuilder, Set<String> visited) {
        if (resultBuilder instanceof NativeQuery.RootReturn) {
            NativeQuery.RootReturn rootReturn = (NativeQuery.RootReturn)((Object)resultBuilder);
            String suffix = this.alias2Suffix.get(rootReturn.getTableAlias());
            visited.add(rootReturn.getTableAlias());
            if (suffix == null) {
                resultSetMapping.addResultBuilder(resultBuilder);
            } else {
                DynamicResultBuilderEntityStandard resultBuilderEntity = this.createSuffixedResultBuilder(rootReturn, suffix);
                resultSetMapping.addResultBuilder(resultBuilderEntity);
                this.alias2Return.put(rootReturn.getTableAlias(), resultBuilderEntity);
            }
        } else if (resultBuilder instanceof NativeQuery.CollectionReturn) {
            NativeQuery.CollectionReturn collectionReturn = (NativeQuery.CollectionReturn)((Object)resultBuilder);
            String suffix = this.alias2CollectionSuffix.get(collectionReturn.getTableAlias());
            if (suffix == null) {
                resultSetMapping.addResultBuilder(resultBuilder);
            } else {
                CompleteResultBuilderCollectionStandard resultBuilderCollection = this.createSuffixedResultBuilder(collectionReturn, suffix, this.alias2Suffix.get(collectionReturn.getTableAlias()));
                resultSetMapping.addResultBuilder(resultBuilderCollection);
                this.alias2Return.put(collectionReturn.getTableAlias(), resultBuilderCollection);
            }
        } else {
            resultSetMapping.addResultBuilder(resultBuilder);
        }
    }

    private void applyFetchBuilder(ResultSetMapping resultSetMapping, LegacyFetchBuilder fetchBuilder, Set<String> visited) {
        if (!visited.add(fetchBuilder.getTableAlias())) {
            return;
        }
        String suffix = this.alias2Suffix.get(fetchBuilder.getTableAlias());
        if (suffix == null) {
            resultSetMapping.addLegacyFetchBuilder(fetchBuilder);
        } else {
            if (!visited.contains(fetchBuilder.getOwnerAlias())) {
                this.applyFetchBuilder(resultSetMapping, (DynamicFetchBuilderLegacy)this.alias2Return.get(fetchBuilder.getOwnerAlias()), visited);
            }
            DynamicResultBuilderEntityStandard ownerBuilder = (DynamicResultBuilderEntityStandard)this.alias2Return.get(fetchBuilder.getOwnerAlias());
            DynamicResultBuilderEntityStandard resultBuilderEntity = this.createSuffixedResultBuilder(this.alias2Persister.get(fetchBuilder.getTableAlias()).findContainingEntityMapping(), fetchBuilder.getTableAlias(), suffix, null, this.determineNavigablePath(fetchBuilder));
            ownerBuilder.addFetchBuilder(fetchBuilder.getFetchable(), new DynamicFetchBuilderLegacy(fetchBuilder.getTableAlias(), fetchBuilder.getOwnerAlias(), fetchBuilder.getFetchable(), this.columnNames(resultBuilderEntity, fetchBuilder), Collections.emptyMap(), resultBuilderEntity));
            this.alias2Return.put(fetchBuilder.getTableAlias(), resultBuilderEntity);
        }
    }

    private List<String> columnNames(DynamicResultBuilderEntityStandard resultBuilder, LegacyFetchBuilder fetchBuilder) {
        String[] columnAliases = this.alias2Persister.get(fetchBuilder.getOwnerAlias()).getSubclassPropertyColumnAliases(fetchBuilder.getFetchable().getFetchableName(), this.alias2Suffix.get(fetchBuilder.getOwnerAlias()));
        if (columnAliases.length == 0) {
            CollectionPersister collectionPersister = this.alias2CollectionPersister.get(fetchBuilder.getTableAlias());
            if (collectionPersister == null) {
                return Collections.emptyList();
            }
            String collectionSuffix = this.alias2CollectionSuffix.get(fetchBuilder.getTableAlias());
            if (collectionPersister.hasIndex()) {
                PluralAttributeMapping fetchable = (PluralAttributeMapping)fetchBuilder.getFetchable();
                resultBuilder.addProperty((Fetchable)fetchable.getIndexDescriptor(), collectionPersister.getIndexColumnAliases(collectionSuffix));
            }
            return Arrays.asList(collectionPersister.getKeyColumnAliases(collectionSuffix));
        }
        return Arrays.asList(columnAliases);
    }

    private NavigablePath determineNavigablePath(LegacyFetchBuilder fetchBuilder) {
        NavigablePath basePath;
        NativeQuery.ResultNode ownerResult = this.alias2Return.get(fetchBuilder.getOwnerAlias());
        if (ownerResult instanceof NativeQuery.RootReturn) {
            NativeQuery.RootReturn rootReturn = (NativeQuery.RootReturn)ownerResult;
            basePath = rootReturn.getNavigablePath();
        } else if (ownerResult instanceof DynamicFetchBuilderLegacy) {
            DynamicFetchBuilderLegacy dynamicFetchBuilderLegacy = (DynamicFetchBuilderLegacy)ownerResult;
            basePath = this.determineNavigablePath(dynamicFetchBuilderLegacy);
        } else {
            throw new AssertionFailure("Unexpected fetch builder");
        }
        NavigablePath path = this.alias2CollectionPersister.containsKey(fetchBuilder.getOwnerAlias()) ? basePath.append(CollectionPart.Nature.ELEMENT.getName()) : basePath;
        return path.append(fetchBuilder.getFetchable().getFetchableName());
    }

    private DynamicResultBuilderEntityStandard createSuffixedResultBuilder(NativeQuery.RootReturn rootReturn, String suffix) {
        return this.createSuffixedResultBuilder(rootReturn.getEntityMapping(), rootReturn.getTableAlias(), suffix, rootReturn.getLockMode(), new NavigablePath(rootReturn.getEntityMapping().getEntityName(), rootReturn.getTableAlias()));
    }

    private DynamicResultBuilderEntityStandard createSuffixedResultBuilder(EntityMappingType entityMapping, String tableAlias, String suffix, LockMode lockMode, NavigablePath navigablePath) {
        DynamicResultBuilderEntityStandard resultBuilderEntity = new DynamicResultBuilderEntityStandard(entityMapping, tableAlias, navigablePath);
        resultBuilderEntity.setLockMode(lockMode);
        EntityPersister persister = entityMapping.getEntityPersister();
        String[] identifierAliases = persister.getIdentifierAliases(suffix);
        resultBuilderEntity.addIdColumnAliases(identifierAliases);
        resultBuilderEntity.setDiscriminatorAlias(persister.getDiscriminatorAlias(suffix));
        if (persister.hasIdentifierProperty()) {
            resultBuilderEntity.addProperty((Fetchable)persister.getIdentifierMapping(), identifierAliases);
        }
        persister.visitFetchables((index, fetchable) -> {
            if (fetchable.isSelectable()) {
                Type type;
                String[] stringArray = persister.getSubclassPropertyColumnAliases(fetchable.getFetchableName(), suffix);
                if (persister instanceof SingleTableEntityPersister) {
                    SingleTableEntityPersister singleTableEntityPersister = (SingleTableEntityPersister)persister;
                    type = singleTableEntityPersister.getSubclassPropertyType(index);
                } else {
                    type = persister.getPropertyType(fetchable.getFetchableName());
                }
                this.addFetchBuilder(suffix, persister, resultBuilderEntity, tableAlias, identifierAliases, (Fetchable)fetchable, stringArray, type);
            }
        }, null);
        return resultBuilderEntity;
    }

    private void addFetchBuilder(String suffix, EntityPersister loadable, DynamicFetchBuilderContainer resultBuilderEntity, String tableAlias, String[] identifierAliases, Fetchable fetchable, String[] columnAliases, Type propertyType) {
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            String[] keyColumnAliases = collectionType.useLHSPrimaryKey() ? identifierAliases : loadable.getSubclassPropertyColumnAliases(collectionType.getLHSPropertyName(), suffix);
            resultBuilderEntity.addProperty(fetchable, keyColumnAliases);
        } else if (propertyType instanceof ComponentType) {
            ComponentType componentType = (ComponentType)propertyType;
            DynamicFetchBuilderLegacy fetchBuilder = new DynamicFetchBuilderLegacy("", tableAlias, fetchable, Arrays.asList(columnAliases), new HashMap<Fetchable, FetchBuilder>());
            String[] propertyNames = componentType.getPropertyNames();
            Type[] propertyTypes = componentType.getSubtypes();
            int aliasIndex = 0;
            for (int i = 0; i < propertyNames.length; ++i) {
                Type type = propertyTypes[i];
                int columnSpan = type.getColumnSpan(loadable.getFactory().getRuntimeMetamodels());
                this.addFetchBuilder(suffix, loadable, fetchBuilder, tableAlias, identifierAliases, fetchable, ArrayHelper.slice(columnAliases, aliasIndex, columnSpan), type);
                aliasIndex += columnSpan;
            }
            resultBuilderEntity.addFetchBuilder(fetchable, fetchBuilder);
        } else if (columnAliases.length != 0) {
            ToOneAttributeMapping toOne;
            if (propertyType instanceof EntityType && !(toOne = (ToOneAttributeMapping)fetchable).getIdentifyingColumnsTableExpression().equals(loadable.getTableName())) {
                assert (columnAliases.length == 1);
                String[] targetAliases = new String[]{toOne.getTargetKeyPropertyName()};
                resultBuilderEntity.addProperty(fetchable, targetAliases);
                return;
            }
            resultBuilderEntity.addProperty(fetchable, columnAliases);
        }
    }

    private CompleteResultBuilderCollectionStandard createSuffixedResultBuilder(NativeQuery.CollectionReturn collectionReturn, String suffix, String entitySuffix) {
        CollectionPersister collectionPersister = collectionReturn.getPluralAttribute().getCollectionDescriptor();
        return new CompleteResultBuilderCollectionStandard(collectionReturn.getTableAlias(), collectionReturn.getNavigablePath(), collectionReturn.getPluralAttribute(), collectionPersister.getKeyColumnAliases(suffix), collectionPersister.hasIndex() ? collectionPersister.getIndexColumnAliases(suffix) : null, ResultSetMappingProcessor.getElementColumnAliases(suffix, entitySuffix, collectionPersister));
    }

    private static String[] getElementColumnAliases(String suffix, String entitySuffix, CollectionPersister collectionPersister) {
        if (collectionPersister.getElementType().isEntityType()) {
            EntityPersister elementPersister = collectionPersister.getElementPersister();
            String[] propertyNames = elementPersister.getPropertyNames();
            String[] identifierAliases = elementPersister.getIdentifierAliases(entitySuffix);
            String discriminatorAlias = elementPersister.getDiscriminatorAlias(entitySuffix);
            int size = propertyNames.length + identifierAliases.length + (discriminatorAlias == null ? 0 : 1);
            ArrayList<String> aliases = new ArrayList<String>(size);
            Collections.addAll(aliases, identifierAliases);
            if (discriminatorAlias != null) {
                aliases.add(discriminatorAlias);
            }
            for (int i = 0; i < propertyNames.length; ++i) {
                Collections.addAll(aliases, elementPersister.getPropertyAliases(entitySuffix, i));
            }
            return ArrayHelper.toStringArray(aliases);
        }
        return collectionPersister.getElementColumnAliases(suffix);
    }

    private String generateEntitySuffix() {
        return AliasConstantsHelper.get(this.entitySuffixSeed++);
    }

    private String generateCollectionSuffix() {
        return this.collectionSuffixSeed++ + "__";
    }

    private void processReturn(NativeQuery.ResultNode resultNode) {
        if (resultNode instanceof NativeQuery.RootReturn) {
            NativeQuery.RootReturn rootReturn = (NativeQuery.RootReturn)resultNode;
            this.processRootReturn(rootReturn);
        } else if (resultNode instanceof NativeQuery.FetchReturn) {
            NativeQuery.FetchReturn fetchReturn = (NativeQuery.FetchReturn)resultNode;
            this.processFetchReturn(fetchReturn);
        } else if (resultNode instanceof NativeQuery.InstantiationResultNode) {
            NativeQuery.InstantiationResultNode instantiationResultNode = (NativeQuery.InstantiationResultNode)resultNode;
            this.processConstructorReturn(instantiationResultNode);
        } else if (resultNode instanceof NativeQuery.ReturnProperty) {
            NativeQuery.ReturnProperty returnProperty = (NativeQuery.ReturnProperty)resultNode;
            this.processScalarReturn(returnProperty);
        } else if (resultNode instanceof NativeQuery.ReturnableResultNode) {
            NativeQuery.ReturnableResultNode returnableResultNode = (NativeQuery.ReturnableResultNode)resultNode;
            this.processPropertyReturn(returnableResultNode);
        } else {
            throw new AssertionFailure("Unrecognized ResultNode concrete type: " + String.valueOf(resultNode));
        }
    }

    private void processPropertyReturn(NativeQuery.ReturnableResultNode returnableResultNode) {
    }

    private void processConstructorReturn(NativeQuery.InstantiationResultNode<?> instantiationResultNode) {
    }

    private void processScalarReturn(NativeQuery.ReturnProperty typeReturn) {
    }

    private void processRootReturn(NativeQuery.RootReturn rootReturn) {
        if (!this.alias2Persister.containsKey(rootReturn.getTableAlias())) {
            this.addPersister(rootReturn.getTableAlias(), Collections.emptyMap(), rootReturn.getEntityMapping().getEntityPersister());
        }
    }

    private void addPersister(String alias, Map<String, String[]> propertyResult, EntityPersister persister) {
        this.alias2Persister.put(alias, persister);
        this.alias2Suffix.put(alias, this.generateEntitySuffix());
        this.entityPropertyResultMaps.put(alias, propertyResult);
    }

    private void addCollection(String role, String alias, Map<String, String[]> propertyResults) {
        CollectionPersister collectionDescriptor = this.factory.getMappingMetamodel().getCollectionDescriptor(role);
        this.alias2CollectionPersister.put(alias, collectionDescriptor);
        this.alias2CollectionSuffix.put(alias, this.generateCollectionSuffix());
        this.collectionPropertyResultMaps.put(alias, propertyResults);
        if (collectionDescriptor.isOneToMany() || collectionDescriptor.isManyToMany()) {
            this.addPersister(alias, this.filter(propertyResults), collectionDescriptor.getElementPersister());
        }
    }

    private Map<String, String[]> filter(Map<String, String[]> propertyResults) {
        HashMap<String, String[]> result = new HashMap<String, String[]>(propertyResults.size());
        String keyPrefix = "element.";
        for (Map.Entry<String, String[]> element : propertyResults.entrySet()) {
            String path = element.getKey();
            if (!path.startsWith("element.")) continue;
            result.put(path.substring("element.".length()), element.getValue());
        }
        return result;
    }

    private void processFetchReturn(NativeQuery.FetchReturn fetchReturn) {
        String alias = fetchReturn.getTableAlias();
        if (!this.alias2Persister.containsKey(alias) && !this.alias2CollectionPersister.containsKey(alias)) {
            String fetchableName;
            EntityPersister ownerPersister;
            Type returnType;
            String ownerAlias = fetchReturn.getOwnerAlias();
            if (!this.alias2Return.containsKey(ownerAlias)) {
                throw new HibernateException("Owner alias [" + ownerAlias + "] is unknown for alias [" + alias + "]");
            }
            if (!this.alias2Persister.containsKey(ownerAlias)) {
                this.processReturn(this.alias2Return.get(ownerAlias));
            }
            if ((returnType = (ownerPersister = this.alias2Persister.get(ownerAlias)).getPropertyType(fetchableName = fetchReturn.getFetchable().getFetchableName())) instanceof CollectionType) {
                this.addCollection(ownerPersister.getEntityName() + "." + fetchableName, alias, Collections.emptyMap());
            } else if (returnType instanceof EntityType) {
                EntityType entityType = (EntityType)returnType;
                this.addPersister(alias, Collections.emptyMap(), this.factory.getMappingMetamodel().getEntityDescriptor(entityType.getAssociatedEntityName()));
            }
        }
    }

    @Override
    public boolean isEntityAlias(String alias) {
        return this.getEntityPersister(alias) != null;
    }

    @Override
    public boolean isCollectionAlias(String alias) {
        return this.getCollectionPersister(alias) != null;
    }

    @Override
    public EntityPersister getEntityPersister(String alias) {
        return this.alias2Persister.get(alias);
    }

    @Override
    public CollectionPersister getCollectionPersister(String alias) {
        return this.alias2CollectionPersister.get(alias);
    }

    @Override
    public String getEntitySuffix(String alias) {
        return this.alias2Suffix.get(alias);
    }

    @Override
    public String getCollectionSuffix(String alias) {
        return this.alias2CollectionSuffix.get(alias);
    }

    public String getOwnerAlias(String alias) {
        return this.alias2OwnerAlias.get(alias);
    }

    @Override
    public Map<String, String[]> getPropertyResultsMap(String alias) {
        Map<String, String[]> collectionMap = this.collectionPropertyResultMaps.get(alias);
        if (collectionMap != null) {
            return collectionMap;
        }
        Map<String, String[]> entityMap = this.entityPropertyResultMaps.get(alias);
        if (entityMap != null) {
            return entityMap;
        }
        NativeQuery.ResultNode resultNode = this.alias2Return.get(alias);
        return resultNode instanceof NativeQuery.ReturnProperty && !(resultNode instanceof NativeQuery.FetchReturn) ? null : Collections.emptyMap();
    }
}

