/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import org.hibernate.models.internal.AbstractTypeDescriptor;
import org.hibernate.models.rendering.spi.Renderer;
import org.hibernate.models.rendering.spi.RenderingTarget;
import org.hibernate.models.spi.ModelsContext;

public class FloatTypeDescriptor
extends AbstractTypeDescriptor<Float> {
    public static final FloatTypeDescriptor FLOAT_TYPE_DESCRIPTOR = new FloatTypeDescriptor();

    @Override
    public Class<Float> getValueType() {
        return Float.class;
    }

    @Override
    public Object unwrap(Float value) {
        return value;
    }

    @Override
    public void render(String name, Object attributeValue, RenderingTarget target, Renderer renderer, ModelsContext modelContext) {
        target.addLine("%s = %sF", name, attributeValue);
    }

    @Override
    public void render(Object attributeValue, RenderingTarget target, Renderer renderer, ModelsContext modelContext) {
        target.addLine("%sF", attributeValue);
    }

    public Float[] makeArray(int size, ModelsContext modelContext) {
        return new Float[size];
    }
}

