/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.servlet.jakarta;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import lucee.loader.servlet.jakarta.HttpSessionJavax;
import lucee.loader.servlet.jakarta.PartJavax;
import lucee.loader.servlet.jakarta.ServletExceptionJavax;
import lucee.loader.servlet.jakarta.ServletRequestJavax;

public class HttpServletRequestJavax
extends ServletRequestJavax
implements javax.servlet.http.HttpServletRequest {
    private HttpServletRequest req;

    public HttpServletRequestJavax(HttpServletRequest req) {
        super((ServletRequest)req);
        this.req = req;
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public javax.servlet.http.Cookie[] getCookies() {
        Cookie[] cookies = this.req.getCookies();
        if (cookies == null) {
            return null;
        }
        javax.servlet.http.Cookie[] javaxCookies = new javax.servlet.http.Cookie[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            Cookie c = cookies[i];
            javaxCookies[i] = new javax.servlet.http.Cookie(c.getName(), c.getValue());
            if (c.getComment() != null) {
                javaxCookies[i].setComment(c.getComment());
            }
            if (c.getDomain() != null) {
                javaxCookies[i].setDomain(c.getDomain());
            }
            javaxCookies[i].setHttpOnly(c.isHttpOnly());
            javaxCookies[i].setMaxAge(c.getMaxAge());
            if (c.getPath() != null) {
                javaxCookies[i].setPath(c.getPath());
            }
            javaxCookies[i].setSecure(c.getSecure());
            javaxCookies[i].setVersion(c.getVersion());
        }
        return javaxCookies;
    }

    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.req.getIntHeader(name);
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.req.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.req.getRequestURL();
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        jakarta.servlet.http.HttpSession sess = this.req.getSession(create);
        if (sess == null && !create) {
            return null;
        }
        return new HttpSessionJavax(sess);
    }

    public HttpSession getSession() {
        return this.getSession(false);
    }

    public String changeSessionId() {
        return this.req.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new RuntimeException("the method [authenticate] is not supported");
    }

    public void login(String username, String password) throws ServletException {
        try {
            this.req.login(username, password);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletExceptionJavax(e);
        }
    }

    public void logout() throws ServletException {
        try {
            this.req.logout();
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletExceptionJavax(e);
        }
    }

    public Collection<javax.servlet.http.Part> getParts() throws IOException, ServletException {
        try {
            Collection jakartaParts = this.req.getParts();
            ArrayList<javax.servlet.http.Part> javaxParts = new ArrayList<javax.servlet.http.Part>();
            for (Part jakartaPart : jakartaParts) {
                javaxParts.add(new PartJavax(jakartaPart));
            }
            return javaxParts;
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletExceptionJavax(e);
        }
    }

    public javax.servlet.http.Part getPart(String name) throws IOException, ServletException {
        try {
            return new PartJavax(this.req.getPart(name));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletExceptionJavax(e);
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new RuntimeException("method [upgrade] is not supported");
    }
}

