/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.commands;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.symfony2.commands.Bundle;
import org.netbeans.modules.php.symfony2.options.SymfonyOptions;
import org.netbeans.modules.php.symfony2.options.SymfonyOptionsValidator;
import org.netbeans.modules.php.symfony2.ui.options.SymfonyOptionsPanelController;
import org.openide.filesystems.FileUtil;

public final class InstallerExecutable {
    private static final Logger LOGGER = Logger.getLogger(InstallerExecutable.class.getName());
    public static final String NAME = "symfony";
    private static final String ANSI_PARAM = "--ansi";
    private static final String NO_INTERACTION_PARAM = "--no-interaction";
    private static final String NEW_PARAM = "new";
    private static final String LTS_PARAM = "lts";
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"), "nb-symfony23");
    private final PhpModule phpModule;
    private final String installerPath;
    private File workDir = null;

    InstallerExecutable(String installerPath, @NullAllowed PhpModule phpModule) {
        assert (installerPath != null);
        assert (phpModule != null);
        this.installerPath = installerPath;
        this.phpModule = phpModule;
    }

    @CheckForNull
    public static InstallerExecutable getDefault(@NullAllowed PhpModule phpModule, boolean showOptions) {
        ValidationResult result = new SymfonyOptionsValidator().validate().getResult();
        if (InstallerExecutable.validateResult(result) != null) {
            if (showOptions) {
                UiUtils.showOptions((String)"FrameworksAndTools/Symfony2");
            }
            return null;
        }
        return new InstallerExecutable(SymfonyOptions.getInstance().getInstaller(), phpModule);
    }

    public Future<Integer> run(boolean lts) {
        assert (!EventQueue.isDispatchThread());
        this.resetWorkDir();
        Future task = this.getExecutable().additionalParameters(this.getRunParams(lts)).run(this.getDescriptor());
        assert (task != null) : this.installerPath;
        return task;
    }

    public File getSymfony2Dir() {
        assert (this.assertWorkDirExists());
        return new File(this.getWorkDir(), this.getNewDirectoryName());
    }

    private List<String> getRunParams(boolean lts) {
        ArrayList<String> params = new ArrayList<String>(5);
        params.add(ANSI_PARAM);
        params.add(NO_INTERACTION_PARAM);
        params.add(NEW_PARAM);
        params.add(this.getNewDirectoryName());
        if (lts) {
            params.add(LTS_PARAM);
        }
        return params;
    }

    private String getNewDirectoryName() {
        return this.phpModule.getName();
    }

    private PhpExecutable getExecutable() {
        return new PhpExecutable(this.installerPath).workDir(this.getWorkDir()).displayName(Bundle.InstallerExecutable_run_title(this.phpModule.getDisplayName())).optionsSubcategory("FrameworksAndTools/Symfony2");
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(SymfonyOptionsPanelController.getOptionsPath()).rerunCondition(new ExecutionDescriptor.RerunCondition(){

            public void addChangeListener(ChangeListener listener) {
            }

            public void removeChangeListener(ChangeListener listener) {
            }

            public boolean isRerunPossible() {
                return false;
            }
        });
    }

    private synchronized File getWorkDir() {
        if (this.workDir == null) {
            try {
                this.workDir = Files.createTempDirectory("nb-symfony23-", new FileAttribute[0]).toFile();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                this.workDir = new File(TMP_DIR, new BigInteger(130, new SecureRandom()).toString(32));
            }
            if (!this.workDir.isDirectory() && !this.workDir.mkdirs()) {
                LOGGER.log(Level.INFO, "Cannot create TMP dir {0}", this.workDir);
            }
            FileUtil.refreshFor((File[])new File[]{this.workDir});
        }
        return this.workDir;
    }

    private synchronized void resetWorkDir() {
        this.workDir = null;
    }

    private synchronized boolean assertWorkDirExists() {
        assert (this.workDir != null);
        assert (this.workDir.isDirectory()) : this.workDir;
        return true;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
    }
}

