/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

class Commandline {
    private Process cli;
    private BufferedReader ctOutput;
    private BufferedReader ctError;
    private String executable = SvnModuleConfig.getDefault().getExecutableBinaryPath();
    private boolean canceled = false;

    Commandline() {
        if (this.executable == null || this.executable.trim().equals("")) {
            this.executable = "svn";
        } else {
            File f = new File(this.executable);
            if (f.isDirectory()) {
                this.executable = this.executable + "/svn";
            }
        }
    }

    public void interrupt() {
        try {
            this.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void destroy() throws IOException {
        this.canceled = true;
        if (this.cli != null) {
            this.cli.destroy();
        }
        Subversion.LOG.fine("cli: Process destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void exec(SvnCommand command) throws IOException {
        block78: {
            this.canceled = false;
            command.prepareCommand();
            String cmd = this.executable + " " + command.getStringCommand();
            Subversion.LOG.log(Level.FINE, "cli: Executing \"{0}\"", cmd);
            Subversion.LOG.fine("cli: Creating process...");
            command.commandStarted();
            try {
                this.cli = Runtime.getRuntime().exec(command.getCliArguments(this.executable), this.getEnvVar());
                if (this.canceled) {
                    return;
                }
                this.ctError = new BufferedReader(new InputStreamReader(this.cli.getErrorStream()));
                Subversion.LOG.fine("cli: process created");
                String line = null;
                if (command.hasBinaryOutput()) {
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    int i = -1;
                    if (this.canceled) {
                        return;
                    }
                    Subversion.LOG.fine("cli: ready for binary OUTPUT \"");
                    while (!this.canceled && (i = this.cli.getInputStream().read()) != -1) {
                        b.write(i);
                    }
                    if (Subversion.LOG.isLoggable(Level.FINER)) {
                        Subversion.LOG.log(Level.FINER, "cli: BIN OUTPUT \"{0}\"", new String(b.toByteArray()));
                    }
                    command.output(b.toByteArray());
                }
                while (!this.canceled && (line = this.ctError.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    Subversion.LOG.log(Level.INFO, "cli: ERROR \"{0}\"", line);
                    command.errorText(line);
                }
                if (this.canceled) {
                    return;
                }
                this.cli.waitFor();
                command.commandCompleted(this.cli.exitValue());
            }
            catch (InterruptedException ie) {
                Subversion.LOG.log(Level.INFO, " command interrupted");
                Subversion.LOG.log(Level.FINE, " command interrupted: [" + command.getStringCommand() + "]", ie);
            }
            catch (InterruptedIOException ie) {
                Subversion.LOG.log(Level.INFO, " command interrupted");
                Subversion.LOG.log(Level.FINE, " command interrupted: [" + command.getStringCommand() + "]", ie);
            }
            catch (Throwable t) {
                if (this.canceled) {
                    Subversion.LOG.fine(t.getMessage());
                    break block78;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(t);
            }
            finally {
                if (this.cli != null) {
                    try {
                        this.cli.getErrorStream().close();
                    }
                    catch (IOException ie) {}
                    try {
                        this.cli.getInputStream().close();
                    }
                    catch (IOException ie) {}
                    try {
                        this.cli.getOutputStream().close();
                    }
                    catch (IOException ie) {}
                }
                this.ctError = null;
                this.ctOutput = null;
                Subversion.LOG.fine("cli: process finnished");
                command.commandFinished();
            }
        }
    }

    private String[] getEnvVar() {
        Map<String, String> vars = System.getenv();
        ArrayList<String> ret = new ArrayList<String>(vars.keySet().size());
        for (String key : vars.keySet()) {
            if (key.equals("LC_ALL")) {
                ret.add("LC_ALL=");
                continue;
            }
            if (key.equals("LC_MESSAGES")) {
                ret.add("LC_MESSAGES=C");
                continue;
            }
            if (key.equals("LC_TIME")) {
                ret.add("LC_TIME=C");
                continue;
            }
            ret.add(key + "=" + vars.get(key));
        }
        if (!vars.containsKey("LC_ALL")) {
            ret.add("LC_ALL=");
        }
        if (!vars.containsKey("LC_MESSAGES")) {
            ret.add("LC_MESSAGES=C");
        }
        if (!vars.containsKey("LC_TIME")) {
            ret.add("LC_TIME=C");
        }
        return ret.toArray(new String[0]);
    }
}

