/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.context.RequestContext;
import org.primefaces.model.SortOrder;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeComparator;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.TreeUtils;
import org.primefaces.util.WidgetBuilder;

public class TreeTableRenderer
extends CoreRenderer {
    private static final String SB_DECODE_SELECTION = TreeTableRenderer.class.getName() + "#decodeSelection";

    public void decode(FacesContext context, UIComponent component) {
        TreeTable tt = (TreeTable)component;
        if (tt.getSelectionMode() != null) {
            this.decodeSelection(context, tt);
        }
        if (tt.isSortRequest(context)) {
            this.decodeSort(context, tt);
        }
        this.decodeBehaviors(context, component);
    }

    protected void decodeSelection(FacesContext context, TreeTable tt) {
        String selectionValue;
        Map params = context.getExternalContext().getRequestParameterMap();
        String selectionMode = tt.getSelectionMode();
        String clientId = tt.getClientId(context);
        if (selectionMode != null && !this.isValueBlank(selectionValue = (String)params.get(tt.getClientId(context) + "_selection"))) {
            if (selectionMode.equals("single")) {
                tt.setRowKey(selectionValue);
                tt.setSelection(tt.getRowNode());
            } else {
                String[] rowKeys = selectionValue.split(",");
                TreeNode[] selection = new TreeNode[rowKeys.length];
                for (int i = 0; i < rowKeys.length; ++i) {
                    tt.setRowKey(rowKeys[i]);
                    selection[i] = tt.getRowNode();
                }
                tt.setSelection(selection);
            }
            tt.setRowKey(null);
        }
        if (tt.isCheckboxSelection() && tt.isSelectionRequest(context)) {
            String selectedNodeRowKey = (String)params.get(clientId + "_instantSelection");
            tt.setRowKey(selectedNodeRowKey);
            TreeNode selectedNode = tt.getRowNode();
            ArrayList<String> descendantRowKeys = new ArrayList<String>();
            tt.populateRowKeys(selectedNode, descendantRowKeys);
            int size = descendantRowKeys.size();
            StringBuilder sb = SharedStringBuilder.get(context, SB_DECODE_SELECTION);
            for (int i = 0; i < size; ++i) {
                sb.append((String)descendantRowKeys.get(i));
                if (i == size - 1) continue;
                sb.append(",");
            }
            RequestContext.getCurrentInstance().addCallbackParam("descendantRowKeys", sb.toString());
            sb.setLength(0);
            descendantRowKeys = null;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TreeTable tt = (TreeTable)component;
        String clientId = tt.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String nodeKey = (String)params.get(clientId + "_expand");
        if (nodeKey != null) {
            tt.setRowKey(nodeKey);
            TreeNode node = tt.getRowNode();
            node.setExpanded(true);
            this.encodeNodeChildren(context, tt, node);
        } else if (tt.isSortRequest(context)) {
            this.encodeSort(context, tt);
        } else {
            this.encodeMarkup(context, tt);
            this.encodeScript(context, tt);
        }
    }

    protected void encodeScript(FacesContext context, TreeTable tt) throws IOException {
        String clientId = tt.getClientId(context);
        String selectionMode = tt.getSelectionMode();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("TreeTable", tt.resolveWidgetVar(), clientId).attr("selectionMode", selectionMode, null).attr("resizableColumns", tt.isResizableColumns(), false).attr("liveResize", tt.isLiveResize(), false).attr("scrollable", tt.isScrollable(), false).attr("scrollHeight", tt.getScrollHeight(), null).attr("scrollWidth", tt.getScrollWidth(), null).attr("nativeElements", tt.isNativeElements(), false);
        this.encodeClientBehaviors(context, tt);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tt.getClientId(context);
        boolean scrollable = tt.isScrollable();
        TreeNode root = tt.getValue();
        if (root.getRowKey() == null) {
            root.setRowKey("root");
            tt.buildRowKeys(root);
            tt.initPreselection();
        }
        if (tt.getValueExpression("sortBy") != null && !tt.isDefaultSorted()) {
            this.sort(tt);
        }
        String containerClass = tt.isResizableColumns() ? "ui-treetable ui-treetable-resizable ui-widget" : "ui-treetable ui-widget";
        containerClass = scrollable ? containerClass + " " + "ui-treetable-scrollable" : containerClass;
        containerClass = tt.getStyleClass() == null ? containerClass : containerClass + " " + tt.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, null);
        if (tt.getStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getStyle(), null);
        }
        if (scrollable) {
            this.encodeScrollableMarkup(context, tt);
        } else {
            this.encodeRegularMarkup(context, tt);
        }
        if (tt.getSelectionMode() != null) {
            this.encodeStateHolder(context, tt, clientId + "_selection", tt.getSelectedRowKeysAsString());
        }
        if (scrollable) {
            this.encodeStateHolder(context, tt, clientId + "_scrollState", tt.getScrollState());
        }
        writer.endElement("div");
    }

    protected void encodeScrollableMarkup(FacesContext context, TreeTable tt) throws IOException {
        String tableStyle = tt.getStyle();
        String tableStyleClass = tt.getStyleClass();
        this.encodeScrollAreaStart(context, tt, "ui-widget-header ui-treetable-scrollable-header", "ui-treetable-scrollable-header-box", tableStyle, tableStyleClass, "header", "ui-treetable-header ui-widget-header ui-corner-top");
        this.encodeThead(context, tt);
        this.encodeScrollAreaEnd(context);
        this.encodeScrollBody(context, tt, tableStyle, tableStyleClass);
        this.encodeScrollAreaStart(context, tt, "ui-widget-header ui-treetable-scrollable-footer", "ui-treetable-scrollable-footer-box", tableStyle, tableStyleClass, "footer", "ui-treetable-footer ui-widget-header ui-corner-bottom");
        this.encodeTfoot(context, tt);
        this.encodeScrollAreaEnd(context);
    }

    protected void encodeScrollBody(FacesContext context, TreeTable tt, String tableStyle, String tableStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String scrollHeight = tt.getScrollHeight();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-treetable-scrollable-body", null);
        if (scrollHeight != null && scrollHeight.indexOf("%") == -1) {
            writer.writeAttribute("style", (Object)("height:" + scrollHeight + "px"), null);
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeColGroup(context, tt);
        this.encodeTbody(context, tt, false);
        writer.endElement("table");
        writer.endElement("div");
    }

    public void encodeColGroup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("colgroup", null);
        for (UIComponent kid : tt.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof Column)) continue;
            writer.startElement("col", null);
            writer.endElement("col");
        }
        writer.endElement("colgroup");
    }

    protected void encodeScrollAreaStart(FacesContext context, TreeTable tt, String containerClass, String containerBoxClass, String tableStyle, String tableStyleClass, String facet, String facetClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerClass, null);
        this.encodeFacet(context, tt, tt.getFacet(facet), facetClass);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerBoxClass, null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
    }

    protected void encodeScrollAreaEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeRegularMarkup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.encodeFacet(context, tt, tt.getFacet("header"), "ui-treetable-header ui-widget-header ui-corner-top");
        writer.startElement("table", (UIComponent)tt);
        writer.writeAttribute("role", (Object)"treegrid", null);
        if (tt.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getTableStyle(), null);
        }
        if (tt.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tt.getTableStyleClass(), null);
        }
        this.encodeThead(context, tt);
        this.encodeTfoot(context, tt);
        this.encodeTbody(context, tt, false);
        writer.endElement("table");
        this.encodeFacet(context, tt, tt.getFacet("footer"), "ui-treetable-footer ui-widget-header ui-corner-bottom");
    }

    protected void encodeThead(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tt.getClientId(context);
        writer.startElement("thead", null);
        writer.writeAttribute("id", (Object)(clientId + "_head"), null);
        writer.startElement("tr", null);
        writer.writeAttribute("role", (Object)"row", null);
        for (int i = 0; i < tt.getChildCount(); ++i) {
            UIComponent kid = (UIComponent)tt.getChildren().get(i);
            if (!(kid instanceof Column) || !kid.isRendered()) continue;
            this.encodeColumnHeader(context, tt, (UIColumn)kid);
        }
        writer.endElement("tr");
        writer.endElement("thead");
    }

    protected void encodeTbody(FacesContext context, TreeTable tt, boolean dataOnly) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TreeNode root = tt.getValue();
        String clientId = tt.getClientId(context);
        boolean empty = root == null || root.getChildCount() == 0;
        UIComponent emptyFacet = tt.getFacet("emptyMessage");
        if (!dataOnly) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", (Object)(clientId + "_data"), null);
            writer.writeAttribute("class", (Object)"ui-treetable-data ui-widget-content", null);
        }
        if (empty) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-treetable-empty-message", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)tt.getColumnsCount(), null);
            if (emptyFacet != null) {
                emptyFacet.encodeAll(context);
            } else {
                writer.write(tt.getEmptyMessage());
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (root != null) {
            this.encodeNodeChildren(context, tt, root);
        }
        tt.setRowKey(null);
        if (!dataOnly) {
            writer.endElement("tbody");
        }
    }

    protected void encodeNode(FacesContext context, TreeTable tt, TreeNode treeNode) throws IOException {
        String userRowStyleClass;
        ResponseWriter writer = context.getResponseWriter();
        String rowKey = treeNode.getRowKey();
        String parentRowKey = treeNode.getParent().getRowKey();
        tt.setRowKey(rowKey);
        String icon = treeNode.isExpanded() ? "ui-treetable-toggler ui-icon ui-icon-triangle-1-s ui-c" : "ui-treetable-toggler ui-icon ui-icon-triangle-1-e ui-c";
        int depth = rowKey.split("_").length - 1;
        String selectionMode = tt.getSelectionMode();
        boolean selectionEnabled = selectionMode != null;
        boolean selectable = treeNode.isSelectable() && selectionEnabled;
        boolean checkboxSelection = selectionEnabled && selectionMode.equals("checkbox");
        boolean selected = treeNode.isSelected();
        boolean partialSelected = treeNode.isPartialSelected();
        boolean nativeElements = tt.isNativeElements();
        String rowStyleClass = selected ? "ui-widget-content ui-state-highlight ui-selected" : "ui-widget-content";
        rowStyleClass = selectable ? rowStyleClass + " " + "ui-treetable-selectable-node" : rowStyleClass;
        rowStyleClass = rowStyleClass + " " + treeNode.getType();
        if (partialSelected) {
            rowStyleClass = rowStyleClass + " " + "ui-treetable-partialselected";
        }
        if ((userRowStyleClass = tt.getRowStyleClass()) != null) {
            rowStyleClass = rowStyleClass + " " + userRowStyleClass;
        }
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(tt.getClientId(context) + "_node_" + rowKey), null);
        writer.writeAttribute("class", (Object)rowStyleClass, null);
        writer.writeAttribute("role", (Object)"row", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(treeNode.isExpanded()), null);
        writer.writeAttribute("data-rk", (Object)rowKey, null);
        if (parentRowKey != null) {
            writer.writeAttribute("data-prk", (Object)parentRowKey, null);
        }
        if (selectionEnabled) {
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        }
        for (int i = 0; i < tt.getChildren().size(); ++i) {
            UIComponent kid = (UIComponent)tt.getChildren().get(i);
            if (!(kid instanceof Column) || !kid.isRendered()) continue;
            Column column = (Column)kid;
            String columnStyleClass = column.getStyleClass();
            String columnStyle = column.getStyle();
            writer.startElement("td", null);
            writer.writeAttribute("role", (Object)"gridcell", null);
            if (columnStyle != null) {
                writer.writeAttribute("style", (Object)columnStyle, null);
            }
            if (columnStyleClass != null) {
                writer.writeAttribute("class", (Object)columnStyleClass, null);
            }
            if (i == 0) {
                for (int j = 0; j < depth; ++j) {
                    writer.startElement("span", null);
                    writer.writeAttribute("class", (Object)"ui-treetable-indent", null);
                    writer.endElement("span");
                }
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)icon, null);
                if (treeNode.isLeaf()) {
                    writer.writeAttribute("style", (Object)"visibility:hidden", null);
                }
                writer.endElement("span");
                if (selectable && checkboxSelection) {
                    if (!nativeElements) {
                        RendererUtils.encodeCheckbox(context, selected, partialSelected);
                    } else {
                        this.renderNativeCheckbox(context, tt, selected, partialSelected);
                    }
                }
            }
            column.encodeAll(context);
            writer.endElement("td");
        }
        writer.endElement("tr");
        if (treeNode.isExpanded()) {
            this.encodeNodeChildren(context, tt, treeNode);
        }
    }

    protected void encodeColumnHeader(FacesContext context, TreeTable tt, UIColumn column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        ValueExpression columnSortByVE = column.getValueExpression("sortBy");
        boolean sortable = columnSortByVE != null;
        String sortIcon = null;
        String style = column.getStyle();
        String columnClass = sortable ? "ui-state-default ui-sortable-column" : "ui-state-default";
        String userColumnClass = column.getStyleClass();
        if (column.isResizable()) {
            columnClass = columnClass + " " + "ui-resizable-column";
        }
        if (userColumnClass != null) {
            columnClass = columnClass + " " + userColumnClass;
        }
        if (sortable) {
            ValueExpression tableSortByVE = tt.getValueExpression("sortBy");
            if (tableSortByVE != null) {
                sortIcon = this.resolveSortIcon(columnSortByVE, tableSortByVE, tt.getSortOrder());
            }
            if (sortIcon == null) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
            } else {
                columnClass = columnClass + " ui-state-active";
            }
        }
        writer.startElement("th", null);
        writer.writeAttribute("id", (Object)column.getClientId(context), null);
        writer.writeAttribute("class", (Object)columnClass, null);
        writer.writeAttribute("role", (Object)"columnheader", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("span", null);
        if (header != null) {
            header.encodeAll(context);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
        if (sortable) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)sortIcon, null);
            writer.endElement("span");
        }
        writer.endElement("th");
    }

    protected void encodeNodeChildren(FacesContext context, TreeTable tt, TreeNode treeNode) throws IOException {
        int childCount = treeNode.getChildCount();
        if (childCount > 0) {
            List<TreeNode> children = treeNode.getChildren();
            for (int i = 0; i < childCount; ++i) {
                this.encodeNode(context, tt, children.get(i));
            }
        }
    }

    protected void encodeFacet(FacesContext context, TreeTable tt, UIComponent facet, String styleClass) throws IOException {
        if (facet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeTfoot(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tfoot", null);
        if (tt.hasFooterColumn()) {
            writer.startElement("tr", null);
            for (int i = 0; i < tt.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)tt.getChildren().get(i);
                if (!(kid instanceof Column) || !kid.isRendered()) continue;
                Column column = (Column)kid;
                UIComponent footer = column.getFacet("footer");
                String footerText = column.getHeaderText();
                String columnStyleClass = column.getStyleClass() == null ? "ui-state-default" : "ui-state-default " + column.getStyleClass();
                String style = column.getStyle();
                writer.startElement("td", null);
                writer.writeAttribute("class", (Object)columnStyleClass, null);
                if (style != null) {
                    writer.writeAttribute("style", (Object)style, null);
                }
                if (footer != null) {
                    footer.encodeAll(context);
                } else if (footerText != null) {
                    writer.write(footerText);
                }
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeStateHolder(FacesContext context, TreeTable tt, String name, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    protected String resolveSortIcon(ValueExpression columnSortBy, ValueExpression ttSortBy, String sortOrder) {
        String columnSortByExpression = columnSortBy.getExpressionString();
        String ttSortByExpression = ttSortBy.getExpressionString();
        String sortIcon = null;
        if (ttSortByExpression != null && ttSortByExpression.equals(columnSortByExpression)) {
            if (sortOrder.equalsIgnoreCase("ASCENDING")) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
            } else if (sortOrder.equalsIgnoreCase("DESCENDING")) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
            }
        }
        return sortIcon;
    }

    protected void decodeSort(FacesContext context, TreeTable tt) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String sortKey = (String)params.get(clientId + "_sortKey");
        String sortDir = (String)params.get(clientId + "_sortDir");
        Column sortColumn = tt.findColumn(sortKey);
        ValueExpression sortByVE = sortColumn.getValueExpression("sortBy");
        tt.setValueExpression("sortBy", sortByVE);
        tt.setSortColumn(sortColumn);
        tt.setSortFunction(sortColumn.getSortFunction());
        tt.setSortOrder(sortDir);
    }

    protected void encodeSort(FacesContext context, TreeTable tt) throws IOException {
        this.sort(tt);
        this.encodeTbody(context, tt, true);
    }

    public void sort(TreeTable tt) {
        TreeNode root = tt.getValue();
        if (root == null) {
            return;
        }
        ValueExpression sortByVE = tt.getValueExpression("sortBy");
        SortOrder sortOrder = SortOrder.valueOf(tt.getSortOrder().toUpperCase(Locale.ENGLISH));
        TreeUtils.sortNode(root, new TreeNodeComparator(sortByVE, tt.getVar(), sortOrder, tt.getSortFunction(), tt.isCaseSensitiveSort(), tt.resolveDataLocale()));
        tt.updateRowKeys(root);
    }

    protected void renderNativeCheckbox(FacesContext context, TreeTable tt, boolean checked, boolean partialSelected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)(tt.getContainerClientId(context) + "_checkbox"), null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (partialSelected) {
            writer.writeAttribute("class", (Object)"ui-treetable-indeterminate", null);
        }
        writer.endElement("input");
    }
}

