/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.foojay.api.discoclient.pkg.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Distribution {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_UI_STRING = "ui_string";
    public static final String FIELD_API_STRING = "api_string";
    public static final String FIELD_SYNONYMS = "synonyms";
    public static final String FIELD_SCOPES = "scopes";
    public static final String FIELD_MAINTAINED = "maintained";
    public static final String FIELD_BUILD_OF_OPENJDK = "build_of_openjdk";
    public static final String FIELD_BUILD_OF_GRAALVM = "build_of_graalvm";
    private final String name;
    private final String uiString;
    private final String apiString;
    private final List<String> synonyms;
    private final List<Scope> scopes;
    private final boolean maintained;
    private final boolean buildOfOpenJDK;
    private final boolean buildOfGraalVM;

    public Distribution(String name, String uiString, String apiString) {
        this(name, uiString, apiString, List.of(), List.of(), true, true, false);
    }

    public Distribution(String name, String uiString, String apiString, String ... synonyms) {
        this(name, uiString, apiString, Arrays.asList(synonyms), List.of(), true, true, false);
    }

    public Distribution(String name, String uiString, String apiString, List<String> synonyms, List<Scope> scopes, boolean maintained) {
        this(name, uiString, apiString, synonyms, scopes, maintained, true, false);
    }

    public Distribution(String name, String uiString, String apiString, List<String> synonyms, List<Scope> scopes, boolean maintained, boolean buildOfOpenJDK, boolean buildOfGraalVM) {
        this.name = name;
        this.uiString = uiString;
        this.apiString = apiString;
        this.synonyms = new ArrayList<String>(synonyms);
        this.scopes = new ArrayList<Scope>(scopes);
        this.maintained = maintained;
        this.buildOfOpenJDK = buildOfOpenJDK;
        this.buildOfGraalVM = buildOfGraalVM;
    }

    public Distribution(String jsonText) {
        if (null == jsonText || jsonText.isEmpty()) {
            throw new IllegalArgumentException("Json text cannot be null or empty");
        }
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        this.name = json.has(FIELD_NAME) ? json.get(FIELD_NAME).getAsString() : "";
        this.uiString = json.has(FIELD_UI_STRING) ? json.get(FIELD_UI_STRING).getAsString() : "";
        this.apiString = json.has(FIELD_API_STRING) ? json.get(FIELD_API_STRING).getAsString() : "";
        this.synonyms = new ArrayList<String>();
        this.scopes = new ArrayList<Scope>();
        this.maintained = json.has(FIELD_MAINTAINED) ? json.get(FIELD_MAINTAINED).getAsBoolean() : true;
        this.buildOfOpenJDK = json.has(FIELD_BUILD_OF_OPENJDK) ? json.get(FIELD_BUILD_OF_OPENJDK).getAsBoolean() : true;
        boolean bl = this.buildOfGraalVM = json.has(FIELD_BUILD_OF_GRAALVM) ? json.get(FIELD_BUILD_OF_GRAALVM).getAsBoolean() : false;
        if (json.has(FIELD_SYNONYMS)) {
            JsonArray synonyms = json.get(FIELD_SYNONYMS).getAsJsonArray();
            synonyms.forEach(element -> this.synonyms.add(element.getAsString()));
        }
        if (json.has(FIELD_SCOPES)) {
            JsonArray scopes = json.get(FIELD_SCOPES).getAsJsonArray();
            scopes.forEach(element -> {
                Scope scopeFound = Scope.fromText(element.getAsString());
                if (Scope.NOT_FOUND != scopeFound) {
                    this.scopes.add(scopeFound);
                }
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUiString() {
        return this.uiString;
    }

    public String getApiString() {
        return this.apiString;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public boolean isMaintained() {
        return this.maintained;
    }

    public boolean isBuildOfOpenJDK() {
        return this.buildOfOpenJDK;
    }

    public boolean isBuildOfGraalVM() {
        return this.buildOfGraalVM;
    }

    public Distribution getFromText(String text) {
        return this.synonyms.contains(text) ? this : null;
    }

    public String toString() {
        return "{" + "\"" + FIELD_NAME + "\"" + ":" + "\"" + this.name + "\"" + "," + "\"" + FIELD_UI_STRING + "\"" + ":" + "\"" + this.uiString + "\"" + "," + "\"" + FIELD_API_STRING + "\"" + ":" + "\"" + this.apiString + "\"" + "," + "\"" + FIELD_MAINTAINED + "\"" + ":" + "\"" + this.maintained + "," + "\"" + FIELD_BUILD_OF_OPENJDK + "\"" + ":" + "\"" + this.buildOfOpenJDK + "," + "\"" + FIELD_BUILD_OF_GRAALVM + "\"" + ":" + "\"" + this.buildOfGraalVM + "," + "\"" + FIELD_SYNONYMS + "\"" + ":" + "\"" + this.synonyms.stream().collect(Collectors.joining("\",\"", "[\"", "\"]")) + "," + "\"" + FIELD_SCOPES + "\"" + ":" + "\"" + this.scopes.stream().map(scope -> scope.getApiString()).collect(Collectors.joining("\",\"", "[\"", "\"]")) + "}";
    }
}

