/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.Bundle;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class ModuleLogicalView
implements LogicalViewProvider {
    @NonNull
    private final NbModuleProject project;

    public ModuleLogicalView(@NonNull NbModuleProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        return new RootNode(this.project);
    }

    public Node findPath(Node root, Object target) {
        DataObject file;
        if (root.getLookup().lookup(NbModuleProject.class) != this.project) {
            return null;
        }
        if (target instanceof FileObject) {
            try {
                file = DataObject.find((FileObject)((FileObject)target));
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        } else if (target instanceof DataObject) {
            file = (DataObject)target;
        } else {
            return null;
        }
        for (Node rootChild : root.getChildren().getNodes(true)) {
            Node found = PackageView.findPath((Node)rootChild, (Object)target);
            if (found != null) {
                return found;
            }
            if (!rootChild.getName().equals("important.files")) continue;
            for (Node ifChild : rootChild.getChildren().getNodes(true)) {
                if (ifChild.getLookup().lookup(DataObject.class) != file) continue;
                return ifChild;
            }
        }
        return null;
    }

    private static final class RootNode
    extends AbstractNode
    implements PropertyChangeListener {
        @NonNull
        private final NbModuleProject project;
        @NonNull
        private final ProjectInformation pi;

        RootNode(@NonNull NbModuleProject project) {
            super(NodeFactorySupport.createCompositeChildren((Project)project, (String)"Projects/org-netbeans-modules-apisupport-project/Nodes"), Lookups.fixed((Object[])new Object[]{project, DataFolder.findFolder((FileObject)project.getProjectDirectory()), project.getProjectDirectory()}));
            Attributes attrs;
            this.project = project;
            boolean osgi = false;
            Manifest man = project.getManifest();
            if (man != null && (attrs = man.getMainAttributes()) != null) {
                osgi = attrs.getValue("Bundle-SymbolicName") != null;
            }
            this.setIconBaseWithExtension(osgi ? "org/netbeans/modules/apisupport/project/resources/bundle.png" : "org/netbeans/modules/apisupport/project/resources/module.png");
            this.pi = ProjectUtils.getInformation((Project)project);
            this.setDisplayName(this.pi.getDisplayName());
            this.setShortDescription(Bundle.HINT_project_root_node(FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())));
            this.pi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pi));
        }

        public Action[] getActions(boolean ignore) {
            return ModuleActions.getProjectActions(this.project);
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return this.pi.getDisplayName();
        }

        public void setName(String name) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, (String)name);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                @Override
                public void run() {
                    this.fireNameChange(null, null);
                    this.fireDisplayNameChange(null, null);
                }
            });
        }
    }
}

