/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.output;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.terminal.api.IONotifier;
import org.netbeans.modules.terminal.api.IOResizable;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class TerminalResizeListener
implements PropertyChangeListener,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(TerminalResizeListener.class.getName());
    private static final int RESIZE_DELAY = 500;
    private static final RequestProcessor RP = new RequestProcessor(TerminalResizeListener.class);
    private final InputOutput io;
    private final DockerContainer container;
    private final RequestProcessor.Task task;
    private Dimension value;
    private boolean initial = true;

    public TerminalResizeListener(InputOutput io, DockerContainer container) {
        this.io = io;
        this.container = container;
        this.task = RP.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Dimension newValue;
                TerminalResizeListener terminalResizeListener = TerminalResizeListener.this;
                synchronized (terminalResizeListener) {
                    newValue = TerminalResizeListener.this.value;
                }
                DockerAction remote = new DockerAction(TerminalResizeListener.this.container.getInstance());
                try {
                    remote.resizeTerminal(TerminalResizeListener.this.container, newValue.height, newValue.width);
                }
                catch (DockerException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("IOResizable.PROP_SIZE".equals(evt.getPropertyName())) {
            IOResizable.Size newVal = (IOResizable.Size)evt.getNewValue();
            TerminalResizeListener terminalResizeListener = this;
            synchronized (terminalResizeListener) {
                this.value = newVal.cells;
            }
            if (this.initial) {
                this.initial = false;
                this.task.schedule(0);
            } else {
                this.task.schedule(500);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.task.cancel();
        if (IONotifier.isSupported((InputOutput)this.io)) {
            IONotifier.removePropertyChangeListener((InputOutput)this.io, (PropertyChangeListener)this);
        }
    }
}

