/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.oracle.bmc.containerengine.ContainerEngine;
import com.oracle.bmc.containerengine.model.AddonOptionSummary;
import com.oracle.bmc.containerengine.model.AddonSummary;
import com.oracle.bmc.containerengine.model.ClusterSummary;
import com.oracle.bmc.containerengine.model.NodePoolSummary;
import com.oracle.bmc.containerengine.model.PodShapeSummary;
import com.oracle.bmc.containerengine.model.VirtualNodePoolSummary;
import com.oracle.bmc.containerengine.model.VirtualNodeSummary;
import com.oracle.bmc.containerengine.model.WorkRequestSummary;
import com.oracle.bmc.containerengine.model.WorkloadMappingSummary;
import com.oracle.bmc.containerengine.requests.ListAddonOptionsRequest;
import com.oracle.bmc.containerengine.requests.ListAddonsRequest;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.containerengine.requests.ListNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListPodShapesRequest;
import com.oracle.bmc.containerengine.requests.ListVirtualNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListVirtualNodesRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkloadMappingsRequest;
import com.oracle.bmc.containerengine.responses.ListAddonOptionsResponse;
import com.oracle.bmc.containerengine.responses.ListAddonsResponse;
import com.oracle.bmc.containerengine.responses.ListClustersResponse;
import com.oracle.bmc.containerengine.responses.ListNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListPodShapesResponse;
import com.oracle.bmc.containerengine.responses.ListVirtualNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListVirtualNodesResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkloadMappingsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ContainerEnginePaginators {
    private final ContainerEngine client;

    public ContainerEnginePaginators(ContainerEngine client) {
        this.client = client;
    }

    public Iterable<ListAddonOptionsResponse> listAddonOptionsResponseIterator(final ListAddonOptionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAddonOptionsRequest.Builder>(){

            @Override
            public ListAddonOptionsRequest.Builder get() {
                return ListAddonOptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAddonOptionsResponse, String>(){

            @Override
            public String apply(ListAddonOptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAddonOptionsRequest.Builder>, ListAddonOptionsRequest>(){

            @Override
            public ListAddonOptionsRequest apply(RequestBuilderAndToken<ListAddonOptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAddonOptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAddonOptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAddonOptionsRequest, ListAddonOptionsResponse>(){

            @Override
            public ListAddonOptionsResponse apply(ListAddonOptionsRequest request) {
                return ContainerEnginePaginators.this.client.listAddonOptions(request);
            }
        });
    }

    public Iterable<AddonOptionSummary> listAddonOptionsRecordIterator(final ListAddonOptionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAddonOptionsRequest.Builder>(){

            @Override
            public ListAddonOptionsRequest.Builder get() {
                return ListAddonOptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAddonOptionsResponse, String>(){

            @Override
            public String apply(ListAddonOptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAddonOptionsRequest.Builder>, ListAddonOptionsRequest>(){

            @Override
            public ListAddonOptionsRequest apply(RequestBuilderAndToken<ListAddonOptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAddonOptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAddonOptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAddonOptionsRequest, ListAddonOptionsResponse>(){

            @Override
            public ListAddonOptionsResponse apply(ListAddonOptionsRequest request) {
                return ContainerEnginePaginators.this.client.listAddonOptions(request);
            }
        }, (Function)new Function<ListAddonOptionsResponse, List<AddonOptionSummary>>(){

            @Override
            public List<AddonOptionSummary> apply(ListAddonOptionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAddonsResponse> listAddonsResponseIterator(final ListAddonsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAddonsRequest.Builder>(){

            @Override
            public ListAddonsRequest.Builder get() {
                return ListAddonsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAddonsResponse, String>(){

            @Override
            public String apply(ListAddonsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAddonsRequest.Builder>, ListAddonsRequest>(){

            @Override
            public ListAddonsRequest apply(RequestBuilderAndToken<ListAddonsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAddonsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAddonsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAddonsRequest, ListAddonsResponse>(){

            @Override
            public ListAddonsResponse apply(ListAddonsRequest request) {
                return ContainerEnginePaginators.this.client.listAddons(request);
            }
        });
    }

    public Iterable<AddonSummary> listAddonsRecordIterator(final ListAddonsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAddonsRequest.Builder>(){

            @Override
            public ListAddonsRequest.Builder get() {
                return ListAddonsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAddonsResponse, String>(){

            @Override
            public String apply(ListAddonsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAddonsRequest.Builder>, ListAddonsRequest>(){

            @Override
            public ListAddonsRequest apply(RequestBuilderAndToken<ListAddonsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAddonsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAddonsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAddonsRequest, ListAddonsResponse>(){

            @Override
            public ListAddonsResponse apply(ListAddonsRequest request) {
                return ContainerEnginePaginators.this.client.listAddons(request);
            }
        }, (Function)new Function<ListAddonsResponse, List<AddonSummary>>(){

            @Override
            public List<AddonSummary> apply(ListAddonsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListClustersResponse> listClustersResponseIterator(final ListClustersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListClustersRequest.Builder>(){

            @Override
            public ListClustersRequest.Builder get() {
                return ListClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListClustersResponse, String>(){

            @Override
            public String apply(ListClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListClustersRequest.Builder>, ListClustersRequest>(){

            @Override
            public ListClustersRequest apply(RequestBuilderAndToken<ListClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListClustersRequest, ListClustersResponse>(){

            @Override
            public ListClustersResponse apply(ListClustersRequest request) {
                return ContainerEnginePaginators.this.client.listClusters(request);
            }
        });
    }

    public Iterable<ClusterSummary> listClustersRecordIterator(final ListClustersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListClustersRequest.Builder>(){

            @Override
            public ListClustersRequest.Builder get() {
                return ListClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListClustersResponse, String>(){

            @Override
            public String apply(ListClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListClustersRequest.Builder>, ListClustersRequest>(){

            @Override
            public ListClustersRequest apply(RequestBuilderAndToken<ListClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListClustersRequest, ListClustersResponse>(){

            @Override
            public ListClustersResponse apply(ListClustersRequest request) {
                return ContainerEnginePaginators.this.client.listClusters(request);
            }
        }, (Function)new Function<ListClustersResponse, List<ClusterSummary>>(){

            @Override
            public List<ClusterSummary> apply(ListClustersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNodePoolsResponse> listNodePoolsResponseIterator(final ListNodePoolsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNodePoolsRequest.Builder>(){

            @Override
            public ListNodePoolsRequest.Builder get() {
                return ListNodePoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNodePoolsResponse, String>(){

            @Override
            public String apply(ListNodePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNodePoolsRequest.Builder>, ListNodePoolsRequest>(){

            @Override
            public ListNodePoolsRequest apply(RequestBuilderAndToken<ListNodePoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNodePoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNodePoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNodePoolsRequest, ListNodePoolsResponse>(){

            @Override
            public ListNodePoolsResponse apply(ListNodePoolsRequest request) {
                return ContainerEnginePaginators.this.client.listNodePools(request);
            }
        });
    }

    public Iterable<NodePoolSummary> listNodePoolsRecordIterator(final ListNodePoolsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNodePoolsRequest.Builder>(){

            @Override
            public ListNodePoolsRequest.Builder get() {
                return ListNodePoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNodePoolsResponse, String>(){

            @Override
            public String apply(ListNodePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNodePoolsRequest.Builder>, ListNodePoolsRequest>(){

            @Override
            public ListNodePoolsRequest apply(RequestBuilderAndToken<ListNodePoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNodePoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNodePoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNodePoolsRequest, ListNodePoolsResponse>(){

            @Override
            public ListNodePoolsResponse apply(ListNodePoolsRequest request) {
                return ContainerEnginePaginators.this.client.listNodePools(request);
            }
        }, (Function)new Function<ListNodePoolsResponse, List<NodePoolSummary>>(){

            @Override
            public List<NodePoolSummary> apply(ListNodePoolsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPodShapesResponse> listPodShapesResponseIterator(final ListPodShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPodShapesRequest.Builder>(){

            @Override
            public ListPodShapesRequest.Builder get() {
                return ListPodShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPodShapesResponse, String>(){

            @Override
            public String apply(ListPodShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPodShapesRequest.Builder>, ListPodShapesRequest>(){

            @Override
            public ListPodShapesRequest apply(RequestBuilderAndToken<ListPodShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPodShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPodShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPodShapesRequest, ListPodShapesResponse>(){

            @Override
            public ListPodShapesResponse apply(ListPodShapesRequest request) {
                return ContainerEnginePaginators.this.client.listPodShapes(request);
            }
        });
    }

    public Iterable<PodShapeSummary> listPodShapesRecordIterator(final ListPodShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPodShapesRequest.Builder>(){

            @Override
            public ListPodShapesRequest.Builder get() {
                return ListPodShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPodShapesResponse, String>(){

            @Override
            public String apply(ListPodShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPodShapesRequest.Builder>, ListPodShapesRequest>(){

            @Override
            public ListPodShapesRequest apply(RequestBuilderAndToken<ListPodShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPodShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPodShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPodShapesRequest, ListPodShapesResponse>(){

            @Override
            public ListPodShapesResponse apply(ListPodShapesRequest request) {
                return ContainerEnginePaginators.this.client.listPodShapes(request);
            }
        }, (Function)new Function<ListPodShapesResponse, List<PodShapeSummary>>(){

            @Override
            public List<PodShapeSummary> apply(ListPodShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVirtualNodePoolsResponse> listVirtualNodePoolsResponseIterator(final ListVirtualNodePoolsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVirtualNodePoolsRequest.Builder>(){

            @Override
            public ListVirtualNodePoolsRequest.Builder get() {
                return ListVirtualNodePoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualNodePoolsResponse, String>(){

            @Override
            public String apply(ListVirtualNodePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualNodePoolsRequest.Builder>, ListVirtualNodePoolsRequest>(){

            @Override
            public ListVirtualNodePoolsRequest apply(RequestBuilderAndToken<ListVirtualNodePoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualNodePoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualNodePoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualNodePoolsRequest, ListVirtualNodePoolsResponse>(){

            @Override
            public ListVirtualNodePoolsResponse apply(ListVirtualNodePoolsRequest request) {
                return ContainerEnginePaginators.this.client.listVirtualNodePools(request);
            }
        });
    }

    public Iterable<VirtualNodePoolSummary> listVirtualNodePoolsRecordIterator(final ListVirtualNodePoolsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVirtualNodePoolsRequest.Builder>(){

            @Override
            public ListVirtualNodePoolsRequest.Builder get() {
                return ListVirtualNodePoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualNodePoolsResponse, String>(){

            @Override
            public String apply(ListVirtualNodePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualNodePoolsRequest.Builder>, ListVirtualNodePoolsRequest>(){

            @Override
            public ListVirtualNodePoolsRequest apply(RequestBuilderAndToken<ListVirtualNodePoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualNodePoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualNodePoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualNodePoolsRequest, ListVirtualNodePoolsResponse>(){

            @Override
            public ListVirtualNodePoolsResponse apply(ListVirtualNodePoolsRequest request) {
                return ContainerEnginePaginators.this.client.listVirtualNodePools(request);
            }
        }, (Function)new Function<ListVirtualNodePoolsResponse, List<VirtualNodePoolSummary>>(){

            @Override
            public List<VirtualNodePoolSummary> apply(ListVirtualNodePoolsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVirtualNodesResponse> listVirtualNodesResponseIterator(final ListVirtualNodesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVirtualNodesRequest.Builder>(){

            @Override
            public ListVirtualNodesRequest.Builder get() {
                return ListVirtualNodesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualNodesResponse, String>(){

            @Override
            public String apply(ListVirtualNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualNodesRequest.Builder>, ListVirtualNodesRequest>(){

            @Override
            public ListVirtualNodesRequest apply(RequestBuilderAndToken<ListVirtualNodesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualNodesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualNodesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualNodesRequest, ListVirtualNodesResponse>(){

            @Override
            public ListVirtualNodesResponse apply(ListVirtualNodesRequest request) {
                return ContainerEnginePaginators.this.client.listVirtualNodes(request);
            }
        });
    }

    public Iterable<VirtualNodeSummary> listVirtualNodesRecordIterator(final ListVirtualNodesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVirtualNodesRequest.Builder>(){

            @Override
            public ListVirtualNodesRequest.Builder get() {
                return ListVirtualNodesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVirtualNodesResponse, String>(){

            @Override
            public String apply(ListVirtualNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVirtualNodesRequest.Builder>, ListVirtualNodesRequest>(){

            @Override
            public ListVirtualNodesRequest apply(RequestBuilderAndToken<ListVirtualNodesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVirtualNodesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVirtualNodesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVirtualNodesRequest, ListVirtualNodesResponse>(){

            @Override
            public ListVirtualNodesResponse apply(ListVirtualNodesRequest request) {
                return ContainerEnginePaginators.this.client.listVirtualNodes(request);
            }
        }, (Function)new Function<ListVirtualNodesResponse, List<VirtualNodeSummary>>(){

            @Override
            public List<VirtualNodeSummary> apply(ListVirtualNodesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ContainerEnginePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ContainerEnginePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkloadMappingsResponse> listWorkloadMappingsResponseIterator(final ListWorkloadMappingsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkloadMappingsRequest.Builder>(){

            @Override
            public ListWorkloadMappingsRequest.Builder get() {
                return ListWorkloadMappingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkloadMappingsResponse, String>(){

            @Override
            public String apply(ListWorkloadMappingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkloadMappingsRequest.Builder>, ListWorkloadMappingsRequest>(){

            @Override
            public ListWorkloadMappingsRequest apply(RequestBuilderAndToken<ListWorkloadMappingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkloadMappingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkloadMappingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkloadMappingsRequest, ListWorkloadMappingsResponse>(){

            @Override
            public ListWorkloadMappingsResponse apply(ListWorkloadMappingsRequest request) {
                return ContainerEnginePaginators.this.client.listWorkloadMappings(request);
            }
        });
    }

    public Iterable<WorkloadMappingSummary> listWorkloadMappingsRecordIterator(final ListWorkloadMappingsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkloadMappingsRequest.Builder>(){

            @Override
            public ListWorkloadMappingsRequest.Builder get() {
                return ListWorkloadMappingsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkloadMappingsResponse, String>(){

            @Override
            public String apply(ListWorkloadMappingsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkloadMappingsRequest.Builder>, ListWorkloadMappingsRequest>(){

            @Override
            public ListWorkloadMappingsRequest apply(RequestBuilderAndToken<ListWorkloadMappingsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkloadMappingsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkloadMappingsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkloadMappingsRequest, ListWorkloadMappingsResponse>(){

            @Override
            public ListWorkloadMappingsResponse apply(ListWorkloadMappingsRequest request) {
                return ContainerEnginePaginators.this.client.listWorkloadMappings(request);
            }
        }, (Function)new Function<ListWorkloadMappingsResponse, List<WorkloadMappingSummary>>(){

            @Override
            public List<WorkloadMappingSummary> apply(ListWorkloadMappingsResponse response) {
                return response.getItems();
            }
        });
    }
}

