/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.MaintenanceRunSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInfrastructureTargetVersionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String targetResourceId;
    private MaintenanceRunSummary.TargetResourceType targetResourceType;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public MaintenanceRunSummary.TargetResourceType getTargetResourceType() {
        return this.targetResourceType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).targetResourceId(this.targetResourceId).targetResourceType(this.targetResourceType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",targetResourceId=").append(String.valueOf(this.targetResourceId));
        sb.append(",targetResourceType=").append(String.valueOf((Object)this.targetResourceType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInfrastructureTargetVersionsRequest)) {
            return false;
        }
        GetInfrastructureTargetVersionsRequest other = (GetInfrastructureTargetVersionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetResourceId, other.targetResourceId) && Objects.equals((Object)this.targetResourceType, (Object)other.targetResourceType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetResourceId == null ? 43 : this.targetResourceId.hashCode());
        result = result * 59 + (this.targetResourceType == null ? 43 : this.targetResourceType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInfrastructureTargetVersionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String targetResourceId = null;
        private MaintenanceRunSummary.TargetResourceType targetResourceType = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public Builder targetResourceType(MaintenanceRunSummary.TargetResourceType targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInfrastructureTargetVersionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.targetResourceId(o.getTargetResourceId());
            this.targetResourceType(o.getTargetResourceType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInfrastructureTargetVersionsRequest build() {
            GetInfrastructureTargetVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInfrastructureTargetVersionsRequest buildWithoutInvocationCallback() {
            GetInfrastructureTargetVersionsRequest request = new GetInfrastructureTargetVersionsRequest();
            request.compartmentId = this.compartmentId;
            request.targetResourceId = this.targetResourceId;
            request.targetResourceType = this.targetResourceType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

