/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.gradle.spi.execute.JavaRuntimeManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class JavaRuntimePlatformBridge
implements JavaRuntimeManager {
    private static final String PROP_PLATFORM_ID = "platform.ant.name";
    private Map<String, JavaRuntimeManager.JavaRuntime> cachedRuntimes = null;
    private boolean listenerInitialized = false;
    private final PropertyChangeListener clearCache;
    private final ChangeSupport support = new ChangeSupport((Object)this);

    public JavaRuntimePlatformBridge() {
        this.clearCache = evt -> {
            this.cachedRuntimes = null;
            this.support.fireChange();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JavaRuntimeManager.JavaRuntime> getAvailableRuntimes() {
        JavaRuntimePlatformBridge javaRuntimePlatformBridge = this;
        synchronized (javaRuntimePlatformBridge) {
            if (this.cachedRuntimes == null) {
                JavaPlatformManager jpm = JavaPlatformManager.getDefault();
                if (!this.listenerInitialized) {
                    jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.clearCache, (Object)jpm));
                    this.listenerInitialized = true;
                }
                HashMap<String, JavaRuntimeManager.JavaRuntime> runtimes = new HashMap<String, JavaRuntimeManager.JavaRuntime>();
                for (JavaPlatform platform : jpm.getInstalledPlatforms()) {
                    String id = (String)platform.getProperties().get(PROP_PLATFORM_ID);
                    if (!platform.isValid() || id == null) continue;
                    FileObject javaInstallDir = (FileObject)platform.getInstallFolders().iterator().next();
                    runtimes.put(id, JavaRuntimeManager.createJavaRuntime((String)id, (String)platform.getDisplayName(), (File)FileUtil.toFile((FileObject)javaInstallDir)));
                }
                this.cachedRuntimes = Collections.unmodifiableMap(runtimes);
            }
            return this.cachedRuntimes;
        }
    }

    public Optional<Runnable> manageRuntimesAction() {
        return Optional.of(() -> PlatformsCustomizer.showCustomizer(null));
    }

    public void addChangeListener(ChangeListener l) {
        this.support.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.support.removeChangeListener(l);
    }
}

