/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.actions;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.core.actions.InvokeOperationAction;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class WebServiceClientActionGroup
extends NodeAction
implements Presenter.Popup {
    public String getName() {
        return NbBundle.getMessage(WebServiceClientActionGroup.class, (String)"LBL_WebServiceClientActionGroup");
    }

    private static SystemAction[] grouped() {
        return new SystemAction[]{SystemAction.get(InvokeOperationAction.class)};
    }

    public JMenuItem getPopupPresenter() {
        Node[] activatedNodes = this.getActivatedNodes();
        if (activatedNodes.length == 1 && this.hasWebServiceClient()) {
            return new LazyMenu();
        }
        JMenuItem i = super.getPopupPresenter();
        i.setVisible(false);
        return i;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    protected void performAction(Node[] activatedNodes) {
        assert (false) : "Should never be called: ";
    }

    private boolean hasWebServiceClient() {
        Node[] activatedNodes = this.getActivatedNodes();
        DataObject dobj = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        if (dobj != null) {
            Project prj = FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile());
            if (prj != null && WebServiceData.getWebServiceData((Project)prj) != null) {
                return true;
            }
            WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)dobj.getPrimaryFile());
            if (clientSupport != null) {
                return true;
            }
        }
        return false;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        boolean enable = this.enable(actionContext.lookup(new Lookup.Template(Node.class)).allInstances().toArray(new Node[0]));
        return enable ? this : null;
    }

    private final class LazyMenu
    extends JMenu {
        public LazyMenu() {
            super(WebServiceClientActionGroup.this.getName());
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (this.getItemCount() == 0) {
                SystemAction[] grouped = WebServiceClientActionGroup.grouped();
                for (int i = 0; i < grouped.length; ++i) {
                    SystemAction action = grouped[i];
                    if (action == null) {
                        this.addSeparator();
                        continue;
                    }
                    if (action instanceof Presenter.Popup) {
                        this.add(((Presenter.Popup)action).getPopupPresenter());
                        continue;
                    }
                    assert (false) : "Action had no popup presenter: " + action;
                }
            }
            return super.getPopupMenu();
        }
    }
}

