/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.netbeans.modules.cloud.oracle.actions.AbstractPasswordPanel;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletAction;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletDialog;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.steps.PasswordStep;
import org.netbeans.modules.cloud.oracle.steps.ReferenceNameStep;
import org.netbeans.modules.cloud.oracle.steps.SuggestedStep;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.netbeans.modules.cloud.oracle.steps.UsernameStep;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class AddADBAction
implements ActionListener {
    private static final RequestProcessor RP = new RequestProcessor(AddADBAction.class);

    @Override
    public void actionPerformed(ActionEvent e) {
        this.addADB();
    }

    public CompletableFuture<DatabaseItem> addADB() {
        CompletableFuture<DatabaseItem> future = new CompletableFuture<DatabaseItem>();
        boolean showSetRefNameStep = CloudAssets.getDefault().itemExistWithoutReferanceName(DatabaseItem.class);
        Steps.NextStepProvider nsProvider = Steps.NextStepProvider.builder().stepForClass(TenancyStep.class, s -> new CompartmentStep()).stepForClass(CompartmentStep.class, s -> new SuggestedStep("Database")).stepForClass(SuggestedStep.class, s -> new UsernameStep()).stepForClass(UsernameStep.class, s -> new PasswordStep(null, (String)s.getValue())).stepForClass(PasswordStep.class, s -> showSetRefNameStep ? new ReferenceNameStep("Database") : null).build();
        Steps.getDefault().executeMultistep(new TenancyStep(), Lookups.fixed((Object[])new Object[]{nsProvider})).thenAccept(values -> {
            String username = (String)values.getValueForStep(UsernameStep.class);
            String password = (String)values.getValueForStep(PasswordStep.class);
            DatabaseItem databaseItem = (DatabaseItem)values.getValueForStep(SuggestedStep.class);
            String referenceName = (String)values.getValueForStep(ReferenceNameStep.class);
            if (showSetRefNameStep && referenceName == null) {
                future.completeExceptionally(new IllegalArgumentException("Reference name not set"));
                return;
            }
            if (referenceName != null) {
                CloudAssets.getDefault().setReferenceName(databaseItem, referenceName);
            }
            this.downloadWallet(databaseItem, username, password, future);
        });
        return future;
    }

    private void downloadWallet(DatabaseItem databaseItem, String username, String password, CompletableFuture future) {
        try {
            DownloadWalletAction action = new DownloadWalletAction(databaseItem);
            DownloadWalletDialog.WalletInfo info = new DownloadWalletDialog.WalletInfo(DownloadWalletDialog.getWalletsDir().getAbsolutePath(), AbstractPasswordPanel.generatePassword(), username, password.toCharArray(), databaseItem);
            RP.post(() -> {
                action.addConnection(info);
                future.complete(databaseItem);
            });
        }
        catch (IOException ex) {
            future.completeExceptionally(ex);
        }
    }
}

