/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.javascript.jstestdriver.JSTestDriverSupport;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class JSTestDriverCustomizerPanel
extends JPanel
implements DocumentListener,
HelpCtx.Provider {
    private static final String LOCATION = "location";
    private static final String USE_BROWSER = "use.browser.";
    private static final String SERVER_URL = "server.url";
    private static final String STRICT_MODE = "strict.mode";
    private DialogDescriptor descriptor;
    private JButton jBrowseButton;
    private JTable jBrowsersTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jLocationTextField;
    private JLabel jRemoteServerLabel;
    private JLabel jRestartNeededLabel;
    private JScrollPane jScrollPane1;
    private JTextField jServerURLTextField;
    private JCheckBox jStrictCheckBox;

    public JSTestDriverCustomizerPanel() {
        this.initComponents();
        String l = JSTestDriverCustomizerPanel.getPersistedLocation();
        this.jLocationTextField.setText(l != null ? l : "");
        this.jLocationTextField.getDocument().addDocumentListener(this);
        this.jStrictCheckBox.setSelected(JSTestDriverCustomizerPanel.isStricModel());
        this.jServerURLTextField.setText(JSTestDriverCustomizerPanel.getServerURL());
        this.jServerURLTextField.getDocument().addDocumentListener(this);
        this.jBrowsersTable.setModel(new BrowsersTableModel());
        this.jBrowsersTable.setDefaultRenderer(TableRow.class, new TableRowCellRenderer());
        this.initTableVisualProperties(this.jBrowsersTable);
        this.jRestartNeededLabel.setVisible(JSTestDriverSupport.getDefault().isRunning() && !JSTestDriverSupport.getDefault().wasStartedExternally());
    }

    private void initTableVisualProperties(JTable table) {
        table.setRowSelectionAllowed(true);
        table.getSelectionModel().setSelectionMode(0);
        table.setTableHeader(null);
        table.setRowHeight(this.jBrowsersTable.getRowHeight() + 4);
        table.setIntercellSpacing(new Dimension(0, 0));
        table.getParent().setBackground(table.getBackground());
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private static String getPersistedLocation() {
        return NbPreferences.forModule(JSTestDriverCustomizerPanel.class).get(LOCATION, null);
    }

    private void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        this.updateValidity();
    }

    private void updateValidity() {
        this.descriptor.setValid(JSTestDriverCustomizerPanel.isValidJSTestDriverJar(this.jLocationTextField.getText()));
        boolean externalServer = JSTestDriverCustomizerPanel.getPort(this.jServerURLTextField.getText()) == -1;
        this.jBrowsersTable.setEnabled(!externalServer);
        this.jStrictCheckBox.setEnabled(!externalServer);
        this.jRestartNeededLabel.setVisible(JSTestDriverSupport.getDefault().isRunning() && !externalServer && !JSTestDriverSupport.getDefault().wasStartedExternally());
        this.jRemoteServerLabel.setVisible(externalServer);
    }

    private static boolean isValidJSTestDriverJar(String s) {
        if (s == null) {
            return false;
        }
        File f = new File(s);
        return f.exists() && JSTestDriverCustomizerPanel.isValidFileName(f);
    }

    private static boolean isValidFileName(File f) {
        return f.getName().toLowerCase().startsWith("jstestdriver") && f.getName().toLowerCase().endsWith(".jar");
    }

    public static boolean showCustomizer() {
        JSTestDriverCustomizerPanel panel = new JSTestDriverCustomizerPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"MSG_CONFIGURE"));
        panel.setDescriptor(descriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setModal(true);
        dialog.setVisible(true);
        dialog.dispose();
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
            if (JSTestDriverSupport.getDefault().isRunning() && JSTestDriverSupport.getDefault().wasStartedExternally()) {
                JSTestDriverSupport.getDefault().forgetCurrentServer();
            }
            Preferences prefs = NbPreferences.forModule(JSTestDriverCustomizerPanel.class);
            prefs.put(LOCATION, panel.jLocationTextField.getText());
            prefs.put(SERVER_URL, panel.jServerURLTextField.getText());
            prefs.putBoolean(STRICT_MODE, panel.jStrictCheckBox.isSelected());
            boolean usesIntegratedBrowser = false;
            for (TableRow row : ((BrowsersTableModel)panel.jBrowsersTable.getModel()).model) {
                prefs.putBoolean(JSTestDriverCustomizerPanel.getBrowserPropertyName(row.getBrowser()), row.isSelected());
                if (!row.isSelected() || !row.hasNbIntegration()) continue;
                usesIntegratedBrowser = true;
            }
            boolean externalServer = JSTestDriverCustomizerPanel.getPort(panel.jServerURLTextField.getText()) == -1;
            JSTestDriverSupport.logUsage(JSTestDriverCustomizerPanel.class, "USG_JSTESTDRIVER_CONFIGURED", new Object[]{externalServer ? "YES" : "NO", usesIntegratedBrowser ? "YES" : "NO"});
            return true;
        }
        return false;
    }

    private static String getBrowserPropertyName(WebBrowser browser) {
        return PropertyUtils.getUsablePropertyName((String)(USE_BROWSER + browser.getId()));
    }

    public static boolean isConfiguredProperly() {
        String l = JSTestDriverCustomizerPanel.getPersistedLocation();
        return JSTestDriverCustomizerPanel.isValidJSTestDriverJar(l);
    }

    public static String getJSTestDriverJar() {
        return JSTestDriverCustomizerPanel.getPersistedLocation();
    }

    public static String getServerURL() {
        return NbPreferences.forModule(JSTestDriverCustomizerPanel.class).get(SERVER_URL, "http://localhost:42442");
    }

    public static boolean isStricModel() {
        return NbPreferences.forModule(JSTestDriverCustomizerPanel.class).getBoolean(STRICT_MODE, false);
    }

    static int getPort(String s) {
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.startsWith("http://localhost:")) {
            try {
                return Integer.parseInt(s.substring(17));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static int getPort() {
        return JSTestDriverCustomizerPanel.getPort(JSTestDriverCustomizerPanel.getServerURL());
    }

    private static List<TableRow> createModel() {
        ArrayList<TableRow> model = new ArrayList<TableRow>();
        for (WebBrowser browser : WebBrowsers.getInstance().getAll(false, false, false, true)) {
            if (browser.isEmbedded()) continue;
            model.add(new TableRow(browser, NbPreferences.forModule(JSTestDriverCustomizerPanel.class).getBoolean(JSTestDriverCustomizerPanel.getBrowserPropertyName(browser), false), browser.hasNetBeansIntegration()));
        }
        return model;
    }

    public static List<WebBrowser> getBrowsers() {
        List<TableRow> model = JSTestDriverCustomizerPanel.createModel();
        ArrayList<WebBrowser> res = new ArrayList<WebBrowser>();
        for (TableRow row : model) {
            if (!row.isSelected()) continue;
            res.add(row.getBrowser());
        }
        return res;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLocationTextField = new JTextField();
        this.jBrowseButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jBrowsersTable = new JTable();
        this.jStrictCheckBox = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jServerURLTextField = new JTextField();
        this.jRestartNeededLabel = new JLabel();
        this.jRemoteServerLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"JSTestDriverCustomizerPanel.jLabel1.text"));
        this.jLocationTextField.setText(NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"JSTestDriverCustomizerPanel.jLocationTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jBrowseButton, (String)NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"JSTestDriverCustomizerPanel.jBrowseButton.text"));
        this.jBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSTestDriverCustomizerPanel.this.jBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"JSTestDriverCustomizerPanel.jLabel2.text"));
        this.jScrollPane1.setViewportView(this.jBrowsersTable);
        Mnemonics.setLocalizedText((AbstractButton)this.jStrictCheckBox, (String)NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"JSTestDriverCustomizerPanel.jStrictCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"JSTestDriverCustomizerPanel.jLabel3.text"));
        this.jServerURLTextField.setText("http://localhost:42442");
        Mnemonics.setLocalizedText((JLabel)this.jRestartNeededLabel, (String)NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"JSTestDriverCustomizerPanel.jRestartNeededLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jRemoteServerLabel, (String)NbBundle.getMessage(JSTestDriverCustomizerPanel.class, (String)"JSTestDriverCustomizerPanel.jRemoteServerLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jLabel2).addComponent(this.jStrictCheckBox).addComponent(this.jRestartNeededLabel).addComponent(this.jRemoteServerLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLocationTextField).addComponent(this.jServerURLTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBrowseButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLocationTextField, -2, -1, -2).addComponent(this.jBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jServerURLTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 157, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStrictCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRestartNeededLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoteServerLabel).addContainerGap()));
    }

    private void jBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isFile() || JSTestDriverCustomizerPanel.isValidFileName(f);
            }

            @Override
            public String getDescription() {
                return "JsTestDriver*.jar";
            }
        });
        File file = new File(this.jLocationTextField.getText());
        if (this.jLocationTextField.getText().length() > 0 && file.exists()) {
            chooser.setSelectedFile(file);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File selected = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jLocationTextField.setText(selected.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.jstestdriver.JSTestDriverCustomizerPanel");
    }

    static /* synthetic */ List access$400() {
        return JSTestDriverCustomizerPanel.createModel();
    }

    private static final class BrowsersTableModel
    extends AbstractTableModel {
        private List<TableRow> model = JSTestDriverCustomizerPanel.access$400();

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return TableRow.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            TableRow item = this.model.get(row);
            switch (column) {
                case 0: {
                    return item.isSelected();
                }
                case 1: {
                    return item;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            TableRow item = this.model.get(row);
            switch (column) {
                case 0: {
                    item.setSelected((Boolean)value);
                }
            }
            this.fireTableCellUpdated(row, column);
        }
    }

    private static final class TableRow {
        private WebBrowser browser;
        private boolean selected;
        private boolean nbIntegration;

        public TableRow(WebBrowser browser, boolean selected, boolean nbIntegration) {
            this.browser = browser;
            this.selected = selected;
            this.nbIntegration = nbIntegration;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean hasNbIntegration() {
            return this.nbIntegration;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public WebBrowser getBrowser() {
            return this.browser;
        }
    }

    private static class TableRowCellRenderer
    extends DefaultTableCellRenderer {
        private TableRowCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof TableRow) {
                TableRow item = (TableRow)value;
                String s = BrowserUISupport.getLongDisplayName((WebBrowser)item.getBrowser());
                return super.getTableCellRendererComponent(table, s, isSelected, false, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    }
}

