/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.adm.model.SortOrder;
import com.oracle.bmc.adm.model.VulnerabilityAudit;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListVulnerabilityAuditsRequest
extends BmcRequest<Void> {
    private String id;
    private String compartmentId;
    private String knowledgeBaseId;
    private Boolean isSuccess;
    private VulnerabilityAudit.LifecycleState lifecycleState;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortBy sortBy;
    private String displayName;

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public Boolean getIsSuccess() {
        return this.isSuccess;
    }

    public VulnerabilityAudit.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).knowledgeBaseId(this.knowledgeBaseId).isSuccess(this.isSuccess).lifecycleState(this.lifecycleState).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).sortBy(this.sortBy).displayName(this.displayName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",knowledgeBaseId=").append(String.valueOf(this.knowledgeBaseId));
        sb.append(",isSuccess=").append(String.valueOf(this.isSuccess));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListVulnerabilityAuditsRequest)) {
            return false;
        }
        ListVulnerabilityAuditsRequest other = (ListVulnerabilityAuditsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.knowledgeBaseId, other.knowledgeBaseId) && Objects.equals(this.isSuccess, other.isSuccess) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.displayName, other.displayName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.knowledgeBaseId == null ? 43 : this.knowledgeBaseId.hashCode());
        result = result * 59 + (this.isSuccess == null ? 43 : this.isSuccess.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListVulnerabilityAuditsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private String compartmentId = null;
        private String knowledgeBaseId = null;
        private Boolean isSuccess = null;
        private VulnerabilityAudit.LifecycleState lifecycleState = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private SortBy sortBy = null;
        private String displayName = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public Builder isSuccess(Boolean isSuccess) {
            this.isSuccess = isSuccess;
            return this;
        }

        public Builder lifecycleState(VulnerabilityAudit.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVulnerabilityAuditsRequest o) {
            this.id(o.getId());
            this.compartmentId(o.getCompartmentId());
            this.knowledgeBaseId(o.getKnowledgeBaseId());
            this.isSuccess(o.getIsSuccess());
            this.lifecycleState(o.getLifecycleState());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortBy(o.getSortBy());
            this.displayName(o.getDisplayName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVulnerabilityAuditsRequest build() {
            ListVulnerabilityAuditsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListVulnerabilityAuditsRequest buildWithoutInvocationCallback() {
            ListVulnerabilityAuditsRequest request = new ListVulnerabilityAuditsRequest();
            request.id = this.id;
            request.compartmentId = this.compartmentId;
            request.knowledgeBaseId = this.knowledgeBaseId;
            request.isSuccess = this.isSuccess;
            request.lifecycleState = this.lifecycleState;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.sortBy = this.sortBy;
            request.displayName = this.displayName;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        MaxObservedCvssV2Score("maxObservedCvssV2Score"),
        MaxObservedCvssV3Score("maxObservedCvssV3Score"),
        TimeCreated("timeCreated"),
        VulnerableArtifactsCount("vulnerableArtifactsCount"),
        MaxObservedCvssV2ScoreWithIgnored("maxObservedCvssV2ScoreWithIgnored"),
        MaxObservedCvssV3ScoreWithIgnored("maxObservedCvssV3ScoreWithIgnored"),
        VulnerableArtifactsCountWithIgnored("vulnerableArtifactsCountWithIgnored");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

