/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.composite;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.ConditionHandler;
import org.openhab.core.automation.internal.composite.AbstractCompositeModuleHandler;
import org.openhab.core.automation.type.CompositeConditionType;

@NonNullByDefault
public class CompositeConditionHandler
extends AbstractCompositeModuleHandler<Condition, CompositeConditionType, ConditionHandler>
implements ConditionHandler {
    public CompositeConditionHandler(Condition condition, CompositeConditionType mt, LinkedHashMap<Condition, @Nullable ConditionHandler> mapModuleToHandler, String ruleUID) {
        super(condition, mt, mapModuleToHandler);
    }

    @Override
    public boolean isSatisfied(Map<String, Object> context) {
        List<Condition> children = this.getChildren();
        Map<String, Object> compositeContext = this.getCompositeContext(context);
        for (Condition child : children) {
            Map<String, Object> childContext = Collections.unmodifiableMap(this.getChildContext(child, compositeContext));
            ConditionHandler childHandler = (ConditionHandler)this.moduleHandlerMap.get(child);
            boolean isSatisfied = childHandler.isSatisfied(childContext);
            if (isSatisfied) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<Condition> getChildren() {
        return ((CompositeConditionType)this.moduleType).getChildren();
    }
}

