/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Branding {
    static final Logger LOGGER = LoggerFactory.getLogger(Branding.class);

    private Branding() {
    }

    public static Properties loadBrandingProperties(boolean ssh) {
        Properties props = new Properties();
        Branding.loadPropsFromResource(props, "org/apache/karaf/shell/console/", ssh);
        Branding.loadPropsFromResource(props, "org/apache/karaf/branding/", ssh);
        Branding.loadPropsFromFile(props, System.getProperty("karaf.etc") + "/", ssh);
        return props;
    }

    private static void loadPropsFromFile(Properties props, String fileName, boolean ssh) {
        Branding.loadPropsFromFile(props, fileName + "branding.properties");
        if (ssh) {
            Branding.loadPropsFromFile(props, fileName + "branding-ssh.properties");
        }
    }

    private static void loadPropsFromFile(Properties props, String fileName) {
        try (FileInputStream is = new FileInputStream(fileName);){
            Branding.loadProps(props, is);
        }
        catch (IOException e) {
            LOGGER.trace("Could not load branding.", (Throwable)e);
        }
    }

    private static void loadPropsFromResource(Properties props, String resource, boolean ssh) {
        Branding.loadPropsFromResource(props, resource + "branding.properties");
        if (ssh) {
            Branding.loadPropsFromResource(props, resource + "branding-ssh.properties");
        }
    }

    private static void loadPropsFromResource(Properties props, String resource) {
        try (InputStream is = Branding.class.getClassLoader().getResourceAsStream(resource);){
            Branding.loadProps(props, is);
        }
        catch (IOException e) {
            LOGGER.trace("Could not load branding.", (Throwable)e);
        }
    }

    private static void loadProps(Properties props, InputStream is) throws IOException {
        if (is != null) {
            props.load(is);
        }
    }
}

