/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class ContainerInitializerModelChange
extends Change {
    private final List<ContainerInitializerModel> containerInitializerModels = new LinkedList<ContainerInitializerModel>();
    private ContainerInitializerModel containerInitializerModel;
    private final List<OsgiContextModel> newModels = new LinkedList<OsgiContextModel>();

    public ContainerInitializerModelChange(OpCode op, ContainerInitializerModel containerInitializerModel, OsgiContextModel ... newModels) {
        super(op);
        this.containerInitializerModels.add(containerInitializerModel);
        this.containerInitializerModel = containerInitializerModel;
        this.newModels.addAll(Arrays.asList(newModels));
    }

    public ContainerInitializerModelChange(OpCode op, List<ContainerInitializerModel> containerInitializerModels) {
        super(op);
        this.containerInitializerModels.addAll(containerInitializerModels);
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.ADD) {
            operations.add(new ContainerInitializerModelChange(OpCode.DELETE, this.containerInitializerModel, new OsgiContextModel[0]));
        }
    }

    public ContainerInitializerModel getContainerInitializerModel() {
        return this.containerInitializerModel;
    }

    public List<ContainerInitializerModel> getContainerInitializerModels() {
        return this.containerInitializerModels;
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitContainerInitializerModelChange(this);
    }

    public List<OsgiContextModel> getNewModels() {
        return this.newModels;
    }

    @Override
    public List<OsgiContextModel> getContextModels() {
        return this.newModels.size() > 0 ? this.newModels : this.containerInitializerModel.getContextModels();
    }

    public String toString() {
        ContainerInitializerModel model = this.containerInitializerModel;
        if (model == null && this.containerInitializerModels.size() == 1) {
            model = this.containerInitializerModels.get(0);
        }
        if (model != null) {
            return (Object)((Object)this.getKind()) + ": " + model;
        }
        return (Object)((Object)this.getKind()) + ": " + this.containerInitializerModels.size() + " container initializer models";
    }
}

