/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;
import org.opensearch.securityanalytics.model.CorrelationRule;

public class IndexCorrelationRuleRequest
extends ActionRequest {
    private String correlationRuleId;
    private CorrelationRule correlationRule;
    private RestRequest.Method method;
    private static final Pattern IS_VALID_RULE_NAME = Pattern.compile("[a-zA-Z0-9 _,-.]{5,50}");

    public IndexCorrelationRuleRequest(String correlationRuleId, CorrelationRule correlationRule, RestRequest.Method method) {
        this.correlationRuleId = correlationRuleId;
        this.correlationRule = correlationRule;
        this.method = method;
    }

    public IndexCorrelationRuleRequest(StreamInput sin) throws IOException {
        this(sin.readString(), CorrelationRule.readFrom(sin), (RestRequest.Method)sin.readEnum(RestRequest.Method.class));
    }

    public ActionRequestValidationException validate() {
        Matcher matcher = IS_VALID_RULE_NAME.matcher(this.correlationRule.getName());
        boolean find = matcher.matches();
        if (!find) {
            throw new ActionRequestValidationException();
        }
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.correlationRuleId);
        this.correlationRule.writeTo(out);
    }

    public String getCorrelationRuleId() {
        return this.correlationRuleId;
    }

    public CorrelationRule getCorrelationRule() {
        return this.correlationRule;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }
}

