/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.dangling.import_index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.admin.indices.dangling.find.FindDanglingIndexAction;
import org.opensearch.action.admin.indices.dangling.find.FindDanglingIndexRequest;
import org.opensearch.action.admin.indices.dangling.find.FindDanglingIndexResponse;
import org.opensearch.action.admin.indices.dangling.find.NodeFindDanglingIndexResponse;
import org.opensearch.action.admin.indices.dangling.import_index.ImportDanglingIndexRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.gateway.LocalAllocateDangledIndices;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

public class TransportImportDanglingIndexAction
extends HandledTransportAction<ImportDanglingIndexRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportImportDanglingIndexAction.class);
    private final LocalAllocateDangledIndices danglingIndexAllocator;
    private final NodeClient nodeClient;

    @Inject
    public TransportImportDanglingIndexAction(ActionFilters actionFilters, TransportService transportService, LocalAllocateDangledIndices danglingIndexAllocator, NodeClient nodeClient) {
        super("cluster:admin/indices/dangling/import", transportService, actionFilters, ImportDanglingIndexRequest::new);
        this.danglingIndexAllocator = danglingIndexAllocator;
        this.nodeClient = nodeClient;
    }

    @Override
    protected void doExecute(Task task, final ImportDanglingIndexRequest importRequest, final ActionListener<AcknowledgedResponse> importListener) {
        this.findDanglingIndex(importRequest, new ActionListener<IndexMetadata>(){
            final /* synthetic */ TransportImportDanglingIndexAction this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(IndexMetadata indexMetaDataToImport) {
                if (!importRequest.isAcceptDataLoss()) {
                    importListener.onFailure((Exception)new IllegalArgumentException("accept_data_loss must be set to true"));
                    return;
                }
                final String indexName = indexMetaDataToImport.getIndex().getName();
                final String indexUUID = indexMetaDataToImport.getIndexUUID();
                this.this$0.danglingIndexAllocator.allocateDangled(Collections.singletonList(indexMetaDataToImport), new ActionListener<LocalAllocateDangledIndices.AllocateDangledResponse>(){

                    public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse allocateDangledResponse) {
                        importListener.onResponse((Object)new AcknowledgedResponse(true));
                    }

                    public void onFailure(Exception e) {
                        logger.debug("Failed to import dangling index [" + indexName + "] [" + indexUUID + "]", (Throwable)e);
                        importListener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                logger.debug("Failed to find dangling index [" + importRequest.getIndexUUID() + "]", (Throwable)e);
                importListener.onFailure(e);
            }
        });
    }

    private void findDanglingIndex(ImportDanglingIndexRequest request, final ActionListener<IndexMetadata> listener) {
        final String indexUUID = request.getIndexUUID();
        this.nodeClient.execute(FindDanglingIndexAction.INSTANCE, new FindDanglingIndexRequest(indexUUID), new ActionListener<FindDanglingIndexResponse>(){

            public void onResponse(FindDanglingIndexResponse response) {
                if (response.hasFailures()) {
                    String nodeIds = response.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.joining(","));
                    OpenSearchException e = new OpenSearchException("Failed to query nodes [" + nodeIds + "]", new Object[0]);
                    for (FailedNodeException failure : response.failures()) {
                        logger.error("Failed to query node [" + failure.nodeId() + "]", (Throwable)((Object)failure));
                        e.addSuppressed((Throwable)((Object)failure));
                    }
                    listener.onFailure((Exception)e);
                    return;
                }
                ArrayList<IndexMetadata> metaDataSortedByVersion = new ArrayList<IndexMetadata>();
                for (NodeFindDanglingIndexResponse each : response.getNodes()) {
                    metaDataSortedByVersion.addAll(each.getDanglingIndexInfo());
                }
                metaDataSortedByVersion.sort(Comparator.comparingLong(IndexMetadata::getVersion));
                if (metaDataSortedByVersion.isEmpty()) {
                    listener.onFailure((Exception)new IllegalArgumentException("No dangling index found for UUID [" + indexUUID + "]"));
                    return;
                }
                logger.debug("Metadata versions {} found for index UUID [{}], selecting the highest", metaDataSortedByVersion.stream().map(IndexMetadata::getVersion).collect(Collectors.toList()), (Object)indexUUID);
                listener.onResponse((Object)((IndexMetadata)metaDataSortedByVersion.get(metaDataSortedByVersion.size() - 1)));
            }

            public void onFailure(Exception exp) {
                listener.onFailure(exp);
            }
        });
    }
}

