/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.util.MergeRules;

import java.util.List;
import java.util.Map;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.util.MergeRules.DeepMergeRule;
import org.opensearch.sql.opensearch.util.MergeRules.LatestRule;
import org.opensearch.sql.opensearch.util.MergeRules.MergeRule;

public class MergeRuleHelper {
    private static final List<MergeRule> RULES = List.of(new DeepMergeRule(), new LatestRule());

    public static MergeRule selectRule(OpenSearchDataType source, OpenSearchDataType target) {
        return RULES.stream().filter(rule -> rule.isMatch(source, target)).findFirst().orElseThrow();
    }

    public static void merge(Map<String, OpenSearchDataType> target, Map<String, OpenSearchDataType> source) {
        for (Map.Entry<String, OpenSearchDataType> entry : source.entrySet()) {
            String key = entry.getKey();
            OpenSearchDataType sourceValue = entry.getValue();
            OpenSearchDataType targetValue = target.get(key);
            MergeRuleHelper.selectRule(sourceValue, targetValue).mergeInto(key, sourceValue, target);
        }
    }
}

