/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.explore;

import com.o19s.es.explore.ExplorerScorer;
import com.o19s.es.explore.PostingsExplorerQuery;
import com.o19s.es.explore.StatisticsHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.opensearch.ltr.settings.LTRSettings;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.ltr.stats.StatName;

public class ExplorerQuery
extends Query {
    private final Query query;
    private final String type;
    private final LTRStats ltrStats;

    public ExplorerQuery(Query query, String type, LTRStats ltrStats) {
        this.query = query;
        this.type = type;
        this.ltrStats = ltrStats;
    }

    private boolean isCollectionScoped() {
        return this.type.endsWith("_count") || this.type.endsWith("_df") || this.type.endsWith("_idf") || this.type.endsWith("_ttf");
    }

    public Query getQuery() {
        return this.query;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((ExplorerQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(ExplorerQuery other) {
        return Objects.equals(this.query, other.query) && Objects.equals(this.type, other.type);
    }

    public Query rewrite(IndexSearcher reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            return new ExplorerQuery(rewritten, this.type, this.ltrStats);
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.type);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        try {
            return this.createWeightInternal(searcher, scoreMode, boost);
        }
        catch (Exception e) {
            this.ltrStats.getStats().get(StatName.LTR_REQUEST_ERROR_COUNT.getName()).increment();
            throw e;
        }
    }

    private Weight createWeightInternal(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        if (!scoreMode.needsScores()) {
            return searcher.createWeight(this.query, scoreMode, boost);
        }
        HashSet terms = new HashSet();
        this.visit(QueryVisitor.termCollector(terms));
        if (this.isCollectionScoped()) {
            float constantScore;
            ClassicSimilarity sim = new ClassicSimilarity();
            StatisticsHelper df_stats = new StatisticsHelper();
            StatisticsHelper idf_stats = new StatisticsHelper();
            StatisticsHelper ttf_stats = new StatisticsHelper();
            for (Term term : terms) {
                TermStates ctx = TermStates.build((IndexSearcher)searcher, (Term)term, (boolean)scoreMode.needsScores());
                if (ctx != null && ctx.docFreq() > 0) {
                    TermStatistics tStats = searcher.termStatistics(term, ctx.docFreq(), ctx.totalTermFreq());
                    df_stats.add(tStats.docFreq());
                    idf_stats.add(sim.idf(tStats.docFreq(), searcher.collectionStatistics(term.field()).docCount()));
                    ttf_stats.add(tStats.totalTermFreq());
                    continue;
                }
                df_stats.add(0.0f);
                idf_stats.add(0.0f);
                ttf_stats.add(0.0f);
            }
            if (terms.size() > 0) {
                switch (this.type) {
                    case "sum_classic_idf": {
                        constantScore = idf_stats.getSum();
                        break;
                    }
                    case "mean_classic_idf": {
                        constantScore = idf_stats.getMean();
                        break;
                    }
                    case "max_classic_idf": {
                        constantScore = idf_stats.getMax();
                        break;
                    }
                    case "min_classic_idf": {
                        constantScore = idf_stats.getMin();
                        break;
                    }
                    case "stddev_classic_idf": {
                        constantScore = idf_stats.getStdDev();
                        break;
                    }
                    case "sum_raw_df": {
                        constantScore = df_stats.getSum();
                        break;
                    }
                    case "min_raw_df": {
                        constantScore = df_stats.getMin();
                        break;
                    }
                    case "max_raw_df": {
                        constantScore = df_stats.getMax();
                        break;
                    }
                    case "mean_raw_df": {
                        constantScore = df_stats.getMean();
                        break;
                    }
                    case "stddev_raw_df": {
                        constantScore = df_stats.getStdDev();
                        break;
                    }
                    case "sum_raw_ttf": {
                        constantScore = ttf_stats.getSum();
                        break;
                    }
                    case "min_raw_ttf": {
                        constantScore = ttf_stats.getMin();
                        break;
                    }
                    case "max_raw_ttf": {
                        constantScore = ttf_stats.getMax();
                        break;
                    }
                    case "mean_raw_ttf": {
                        constantScore = ttf_stats.getMean();
                        break;
                    }
                    case "stddev_raw_ttf": {
                        constantScore = ttf_stats.getStdDev();
                        break;
                    }
                    case "unique_terms_count": {
                        constantScore = terms.size();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid stat type specified.");
                    }
                }
            } else {
                constantScore = 0.0f;
            }
            return new ConstantScoreWeight(this, this, constantScore){
                final /* synthetic */ ExplorerQuery this$0;
                {
                    this.this$0 = this$0;
                    super(arg0, arg1);
                }

                public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                    Scorer scorer = this.scorer(context);
                    int newDoc = scorer.iterator().advance(doc);
                    assert (newDoc == doc);
                    return Explanation.match((Number)Float.valueOf(scorer.score()), (String)("Stat Score: " + this.this$0.type), (Explanation[])new Explanation[0]);
                }

                public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                    return new ScorerSupplier(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Scorer get(long leadCost) throws IOException {
                            return new ConstantScoreScorer(this.this$1.score(), scoreMode, DocIdSetIterator.all((int)context.reader().maxDoc()));
                        }

                        public long cost() {
                            return context.reader().maxDoc();
                        }
                    };
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return true;
                }
            };
        }
        if (this.type.endsWith("_raw_tf") || this.type.endsWith("_raw_tp")) {
            BooleanQuery.Builder qb = new BooleanQuery.Builder();
            for (Term t : terms) {
                qb.add(this.makeBooleanClause(t, this.type));
            }
            Query q = qb.build().rewrite(searcher);
            return new ExplorerWeight(this, searcher.createWeight(q, scoreMode, boost), this.type);
        }
        throw new IllegalArgumentException("Unknown ExplorerQuery type [" + this.type + "]");
    }

    private BooleanClause makeBooleanClause(Term term, String type) throws IllegalArgumentException {
        if (type.endsWith("_raw_tf")) {
            return new BooleanClause((Query)new PostingsExplorerQuery(term, PostingsExplorerQuery.Type.TF), BooleanClause.Occur.SHOULD);
        }
        if (type.endsWith("_raw_tp")) {
            return new BooleanClause((Query)new PostingsExplorerQuery(term, PostingsExplorerQuery.Type.TP), BooleanClause.Occur.SHOULD);
        }
        throw new IllegalArgumentException("Unknown ExplorerQuery type [" + type + "]");
    }

    public String toString(String field) {
        return this.query.toString();
    }

    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
    }

    static class ExplorerWeight
    extends Weight {
        protected final Weight weight;
        private final String type;

        ExplorerWeight(Query q, Weight subWeight, String type) throws IOException {
            super(q);
            this.weight = subWeight;
            this.type = type;
        }

        public void extractTerms(Set<Term> terms) {
            QueryVisitor.termCollector(terms);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                return Explanation.match((Number)Float.valueOf(scorer.score()), (String)("Stat Score: " + this.type), (Explanation[])new Explanation[0]);
            }
            return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.weight.isCacheable(ctx);
        }

        public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
            final Scorer subscorer = this.weight.scorer(context);
            if (subscorer == null) {
                return null;
            }
            return new ScorerSupplier(this){
                final /* synthetic */ ExplorerWeight this$0;
                {
                    this.this$0 = this$0;
                }

                public Scorer get(long leadCost) throws IOException {
                    return new ExplorerScorer(this.this$0.weight, this.this$0.type, subscorer);
                }

                public long cost() {
                    return context.reader().maxDoc();
                }
            };
        }
    }
}

