/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.client.OpenSearchClient;

public class LTRStatsAction
extends ActionType<LTRStatsNodesResponse> {
    public static final String NAME = "cluster:admin/ltr/stats";
    public static final LTRStatsAction INSTANCE = new LTRStatsAction();

    public LTRStatsAction() {
        super(NAME, LTRStatsNodesResponse::new);
    }

    public static class LTRStatsNodesResponse
    extends BaseNodesResponse<LTRStatsNodeResponse>
    implements ToXContent {
        private static final String NODES_KEY = "nodes";
        private final Map<String, Object> clusterStats;

        public LTRStatsNodesResponse(StreamInput in) throws IOException {
            super(in);
            this.clusterStats = in.readMap();
        }

        public LTRStatsNodesResponse(ClusterName clusterName, List<LTRStatsNodeResponse> nodeResponses, List<FailedNodeException> failures, Map<String, Object> clusterStats) {
            super(clusterName, nodeResponses, failures);
            this.clusterStats = clusterStats;
        }

        public Map<String, Object> getClusterStats() {
            return this.clusterStats;
        }

        protected List<LTRStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(LTRStatsNodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<LTRStatsNodeResponse> nodeResponses) throws IOException {
            out.writeList(nodeResponses);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.clusterStats);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Map.Entry<String, Object> clusterStat : this.clusterStats.entrySet()) {
                builder.field(clusterStat.getKey(), clusterStat.getValue());
            }
            builder.startObject(NODES_KEY);
            for (LTRStatsNodeResponse ltrStats : this.getNodes()) {
                builder.startObject(ltrStats.getNode().getId());
                ltrStats.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
    }

    public static class LTRStatsNodesRequest
    extends BaseNodesRequest<LTRStatsNodesRequest> {
        public static final String ALL_STATS_KEY = "_all";
        private Set<String> statsToBeRetrieved;

        public LTRStatsNodesRequest(StreamInput in) throws IOException {
            super(in);
            this.statsToBeRetrieved = in.readSet(StreamInput::readString);
        }

        public LTRStatsNodesRequest(String[] nodeIds) {
            super(nodeIds);
            this.statsToBeRetrieved = new HashSet<String>();
        }

        public void setStatsToBeRetrieved(Set<String> statsToBeRetrieved) {
            this.statsToBeRetrieved = statsToBeRetrieved;
        }

        public Set<String> getStatsToBeRetrieved() {
            return this.statsToBeRetrieved;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringCollection(this.statsToBeRetrieved);
        }
    }

    public static class LTRStatsNodeResponse
    extends BaseNodeResponse
    implements ToXContentFragment {
        private final Map<String, Object> statsMap;

        LTRStatsNodeResponse(StreamInput in) throws IOException {
            super(in);
            this.statsMap = in.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }

        LTRStatsNodeResponse(DiscoveryNode node, Map<String, Object> statsToValues) {
            super(node);
            this.statsMap = statsToValues;
        }

        public Map<String, Object> getStatsMap() {
            return this.statsMap;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.statsMap, StreamOutput::writeString, StreamOutput::writeGenericValue);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Map.Entry<String, Object> stat : this.statsMap.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
            return builder;
        }
    }

    public static class LTRStatsNodeRequest
    extends TransportRequest {
        private final LTRStatsNodesRequest nodesRequest;

        public LTRStatsNodeRequest(LTRStatsNodesRequest nodesRequest) {
            this.nodesRequest = nodesRequest;
        }

        public LTRStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.nodesRequest = new LTRStatsNodesRequest(in);
        }

        public LTRStatsNodesRequest getLTRStatsNodesRequest() {
            return this.nodesRequest;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.nodesRequest.writeTo(out);
        }
    }

    public static class LTRStatsRequestBuilder
    extends ActionRequestBuilder<LTRStatsNodesRequest, LTRStatsNodesResponse> {
        private static final String[] nodeIds = null;

        public LTRStatsRequestBuilder(OpenSearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new LTRStatsNodesRequest(nodeIds));
        }
    }
}

