/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.rest;

import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import com.o19s.es.ltr.query.ValidatingLtrQueryBuilder;
import java.io.IOException;
import java.util.stream.Collectors;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentParser;

class AutoDetectParser {
    private String expectedName;
    private StorableElement element;
    private FeatureValidation validation;
    private static final ObjectParser<AutoDetectParser, String> PARSER = new ObjectParser("storable_elements");

    AutoDetectParser(String name) {
        this.expectedName = name;
    }

    public void parse(XContentParser parser) throws IOException {
        PARSER.parse(parser, (Object)this, (Object)this.expectedName);
        if (this.element == null) {
            throw new ParsingException(parser.getTokenLocation(), "Element of type [" + ValidatingLtrQueryBuilder.SUPPORTED_TYPES.stream().collect(Collectors.joining(",")) + "] is mandatory.", new Object[0]);
        }
    }

    public StorableElement getElement() {
        return this.element;
    }

    public void setElement(StorableElement element) {
        if (this.element != null) {
            throw new IllegalArgumentException("[" + element.type() + "] already set, only one element can be set at a time (" + ValidatingLtrQueryBuilder.SUPPORTED_TYPES.stream().collect(Collectors.joining(",")) + ").");
        }
        this.element = element;
    }

    public void setValidation(FeatureValidation validation) {
        this.validation = validation;
    }

    public FeatureValidation getValidation() {
        return this.validation;
    }

    static {
        PARSER.declareObject(AutoDetectParser::setElement, StoredFeature::parse, new ParseField("feature", new String[0]));
        PARSER.declareObject(AutoDetectParser::setElement, StoredFeatureSet::parse, new ParseField("featureset", new String[0]));
        PARSER.declareObject(AutoDetectParser::setElement, StoredLtrModel::parse, new ParseField("model", new String[0]));
        PARSER.declareObject((b, v) -> {
            b.validation = v;
        }, (p, c) -> (FeatureValidation)FeatureValidation.PARSER.apply(p, null), new ParseField("validation", new String[0]));
    }
}

