/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.QuerySet;
import org.opensearch.searchrelevance.model.QuerySetEntry;

public class QuerySetDao {
    private static final Logger LOGGER = LogManager.getLogger(QuerySetDao.class);
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;

    public QuerySetDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.QUERY_SET, stepListener);
    }

    public void putQuerySet(QuerySet querySet, ActionListener listener) {
        if (querySet == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("QuerySet cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDoc(querySet.id(), querySet.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.QUERY_SET, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store query set", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void deleteQuerySet(String querySetId, ActionListener<DeleteResponse> listener) {
        this.searchRelevanceIndicesManager.deleteDocByDocId(querySetId, SearchRelevanceIndices.QUERY_SET, listener);
    }

    public SearchResponse getQuerySet(String querySetId, ActionListener<SearchResponse> listener) {
        if (querySetId == null || querySetId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("querySetId must not be null or empty", RestStatus.BAD_REQUEST)));
            return null;
        }
        return this.searchRelevanceIndicesManager.getDocByDocId(querySetId, SearchRelevanceIndices.QUERY_SET, listener);
    }

    public QuerySet getQuerySetSync(String querySetId) {
        if (querySetId == null || querySetId.isEmpty()) {
            throw new SearchRelevanceException("querySetId must not be null or empty", RestStatus.BAD_REQUEST);
        }
        SearchResponse response = this.searchRelevanceIndicesManager.getDocByDocIdSync(querySetId, SearchRelevanceIndices.QUERY_SET);
        return this.convertToQuerySet(response);
    }

    public SearchResponse listQuerySet(SearchSourceBuilder sourceBuilder, ActionListener<SearchResponse> listener) {
        if (sourceBuilder == null) {
            sourceBuilder = new SearchSourceBuilder();
        }
        if (sourceBuilder.query() == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.QUERY_SET, listener);
    }

    public void getQuerySetWithStepListener(final String querySetId, final Map<String, Object> results, final StepListener<Map<String, Object>> stepListener) {
        this.getQuerySet(querySetId, new ActionListener<SearchResponse>(){
            final /* synthetic */ QuerySetDao this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(SearchResponse response) {
                try {
                    LOGGER.info("Successfully get response: [{}]", (Object)response);
                    QuerySet querySet = this.this$0.convertToQuerySet(response);
                    LOGGER.debug("Converted response into queryset: [{}]", (Object)querySet);
                    results.put("queryTexts", querySet.querySetQueries().stream().map(QuerySetEntry::queryText).collect(Collectors.toList()));
                    stepListener.onResponse((Object)results);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to convert response: [{}] into queryset.", (Object)response);
                    stepListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to convert queryset", e, RestStatus.INTERNAL_SERVER_ERROR)));
                }
            }

            public void onFailure(Exception e) {
                LOGGER.error("Failed to retrieve query set for querySetId: [{}]", (Object)querySetId, (Object)e);
                stepListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed retrieve queryset", e, RestStatus.INTERNAL_SERVER_ERROR)));
            }
        });
    }

    private QuerySet convertToQuerySet(SearchResponse response) {
        SearchHit hit = response.getHits().getHits()[0];
        Map sourceMap = hit.getSourceAsMap();
        ArrayList<QuerySetEntry> querySetEntries = new ArrayList();
        Object querySetQueriesObj = sourceMap.get("querySetQueries");
        if (querySetQueriesObj instanceof List) {
            List querySetQueriesList = (List)querySetQueriesObj;
            querySetEntries = querySetQueriesList.stream().map(entryMap -> QuerySetEntry.Builder.builder().queryText((String)entryMap.get("queryText")).build()).collect(Collectors.toList());
        }
        return QuerySet.Builder.builder().id((String)sourceMap.get("id")).name((String)sourceMap.get("name")).description((String)sourceMap.get("description")).timestamp((String)sourceMap.get("timestamp")).sampling((String)sourceMap.get("sampling")).querySetQueries(querySetEntries).build();
    }
}

