/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.packed.AbstractPagedMutable;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

final class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private AbstractPagedMutable<?> values;
    private final long minValue;

    NumericDocValuesFieldUpdates(long delGen, String field, int maxDoc) {
        super(maxDoc, delGen, field, DocValuesType.NUMERIC);
        this.values = new PagedGrowableWriter(1L, 1024, 1, 0.25f);
        this.minValue = 0L;
    }

    NumericDocValuesFieldUpdates(long delGen, String field, long minValue, long maxValue, int maxDoc) {
        super(maxDoc, delGen, field, DocValuesType.NUMERIC);
        assert (minValue <= maxValue) : "minValue must be <= maxValue [" + minValue + " > " + maxValue + "]";
        int bitsPerValue = PackedInts.unsignedBitsRequired(maxValue - minValue);
        this.values = new PagedMutable(1L, 1024, bitsPerValue, 0.25f);
        this.minValue = minValue;
    }

    @Override
    void add(int doc, BytesRef value) {
        throw new UnsupportedOperationException();
    }

    @Override
    void add(int docId, DocValuesFieldUpdates.Iterator iterator) {
        this.add(docId, iterator.longValue());
    }

    @Override
    synchronized void add(int doc, long value) {
        int add = this.add(doc);
        this.values.set(add, value - this.minValue);
    }

    @Override
    protected void swap(int i, int j) {
        super.swap(i, j);
        long tmpVal = this.values.get(j);
        this.values.set(j, this.values.get(i));
        this.values.set(i, tmpVal);
    }

    @Override
    protected void grow(int size) {
        super.grow(size);
        this.values = this.values.grow(size);
    }

    @Override
    protected void resize(int size) {
        super.resize(size);
        this.values = this.values.resize(size);
    }

    @Override
    Iterator iterator() {
        this.ensureFinished();
        return new Iterator(this.size, this.minValue, this.values, this.docs, this.delGen);
    }

    @Override
    public long ramBytesUsed() {
        return this.values.ramBytesUsed() + super.ramBytesUsed() + 8L + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    static final class Iterator
    extends DocValuesFieldUpdates.AbstractIterator {
        private final AbstractPagedMutable<?> values;
        private final long minValue;
        private long value;

        Iterator(int size, long minValue, AbstractPagedMutable<?> values, PagedMutable docs, long delGen) {
            super(size, docs, delGen);
            this.values = values;
            this.minValue = minValue;
        }

        @Override
        long longValue() {
            return this.value;
        }

        @Override
        BytesRef binaryValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void set(long idx) {
            this.value = this.values.get(idx) + this.minValue;
        }
    }

    static class SingleValueNumericDocValuesFieldUpdates
    extends DocValuesFieldUpdates {
        private final long value;
        private final BitSet bitSet;
        private BitSet hasNoValue;
        private boolean hasAtLeastOneValue;

        SingleValueNumericDocValuesFieldUpdates(long delGen, String field, int maxDoc, long value) {
            super(maxDoc, delGen, field, DocValuesType.NUMERIC);
            this.bitSet = new SparseFixedBitSet(maxDoc);
            this.value = value;
        }

        long longValue() {
            return this.value;
        }

        @Override
        void add(int doc, long value) {
            assert (this.value == value);
            this.bitSet.set(doc);
            this.hasAtLeastOneValue = true;
            if (this.hasNoValue != null) {
                this.hasNoValue.clear(doc);
            }
        }

        @Override
        void add(int doc, BytesRef value) {
            throw new UnsupportedOperationException();
        }

        @Override
        synchronized void reset(int doc) {
            this.bitSet.set(doc);
            this.hasAtLeastOneValue = true;
            if (this.hasNoValue == null) {
                this.hasNoValue = new SparseFixedBitSet(this.maxDoc);
            }
            this.hasNoValue.set(doc);
        }

        @Override
        void add(int docId, DocValuesFieldUpdates.Iterator iterator) {
            throw new UnsupportedOperationException();
        }

        @Override
        synchronized boolean any() {
            return super.any() || this.hasAtLeastOneValue;
        }

        @Override
        public long ramBytesUsed() {
            return super.ramBytesUsed() + this.bitSet.ramBytesUsed() + (this.hasNoValue == null ? 0L : this.hasNoValue.ramBytesUsed());
        }

        @Override
        DocValuesFieldUpdates.Iterator iterator() {
            final BitSetIterator iterator = new BitSetIterator(this.bitSet, this.maxDoc);
            return new DocValuesFieldUpdates.Iterator(){

                @Override
                public int docID() {
                    return iterator.docID();
                }

                @Override
                public int nextDoc() {
                    return iterator.nextDoc();
                }

                @Override
                long longValue() {
                    return value;
                }

                @Override
                BytesRef binaryValue() {
                    throw new UnsupportedOperationException();
                }

                @Override
                long delGen() {
                    return delGen;
                }

                @Override
                boolean hasValue() {
                    if (hasNoValue != null) {
                        return !hasNoValue.get(this.docID());
                    }
                    return true;
                }
            };
        }
    }
}

